package com.temboo.Library.CorpWatch.Lists;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListLocations

Returns a list of locations of companies matching the given query.
*/
public class ListLocations extends Choreography {

	/**
	Create a new instance of the ListLocations Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListLocations(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/CorpWatch/Lists/ListLocations"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListLocationsInputSet
	*/
	public ListLocationsInputSet newInputSet() {
		return new ListLocationsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListLocationsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListLocationsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListLocations
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListLocationsInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (optional, string) The APIKey from CorpWatch if you have one.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Address input for this Choreo. 

		@param String - (optional, string) Enter an address fragment to search for. This can be either a street address, city, or state/subregion.
		*/
		public void set_Address(String value) {
			this.setInput("Address", value);
		}


		/** 
		Set the value of the CountryCode input for this Choreo. 

		@param String - (optional, string) Enter an ISO-3166 formatted country code. 
		*/
		public void set_CountryCode(String value) {
			this.setInput("CountryCode", value);
		}


		/** 
		Set the value of the Index input for this Choreo. 

		@param Integer - (optional, integer) Set the index number of the first result to be returned. The index of the first result is 0.
		*/
		public void set_Index(Integer value) {
			this.setInput("Index", value);
		}

		/** 
		Set the value of the Index input for this Choreo as a String. 

		@param String - (optional, integer) Set the index number of the first result to be returned. The index of the first result is 0.
		*/
		public void set_Index(String value) {
			this.setInput("Index", value);	
		}
		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The number of results to be returned. Defaults to 100. Maximum is 5000.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to be returned. Defaults to 100. Maximum is 5000.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the MaxYear input for this Choreo. 

		@param Integer - (optional, integer) Indicate desired year of the most recent appearance in SEC filing data (e.g. indicating 2007 will search for companies that ceased filing in 2007).
		*/
		public void set_MaxYear(Integer value) {
			this.setInput("MaxYear", value);
		}

		/** 
		Set the value of the MaxYear input for this Choreo as a String. 

		@param String - (optional, integer) Indicate desired year of the most recent appearance in SEC filing data (e.g. indicating 2007 will search for companies that ceased filing in 2007).
		*/
		public void set_MaxYear(String value) {
			this.setInput("MaxYear", value);	
		}
		/** 
		Set the value of the MinYear input for this Choreo. 

		@param Integer - (optional, integer) Indicate desired year of the earliest appearance in SEC filing data (e.g. indicating 2004 will search for companies that started filing in 2004).
		*/
		public void set_MinYear(Integer value) {
			this.setInput("MinYear", value);
		}

		/** 
		Set the value of the MinYear input for this Choreo as a String. 

		@param String - (optional, integer) Indicate desired year of the earliest appearance in SEC filing data (e.g. indicating 2004 will search for companies that started filing in 2004).
		*/
		public void set_MinYear(String value) {
			this.setInput("MinYear", value);	
		}
		/** 
		Set the value of the PostalCode input for this Choreo. 

		@param Integer - (optional, integer) Enter a postal code to be searched.
		*/
		public void set_PostalCode(Integer value) {
			this.setInput("PostalCode", value);
		}

		/** 
		Set the value of the PostalCode input for this Choreo as a String. 

		@param String - (optional, integer) Enter a postal code to be searched.
		*/
		public void set_PostalCode(String value) {
			this.setInput("PostalCode", value);	
		}
		/** 
		Set the value of the ResponseType input for this Choreo. 

		@param String - (optional, string) Specify json or xml for the type of response to be returned. Defaults to xml.
		*/
		public void set_ResponseType(String value) {
			this.setInput("ResponseType", value);
		}


		/** 
		Set the value of the Type input for this Choreo. 

		@param String - (optional, string) Indicates the origin of the location information found. Acceptable values: relation_loc, business, mailing, state_of_incorp. See documentation for more info.
		*/
		public void set_Type(String value) {
			this.setInput("Type", value);
		}


		/** 
		Set the value of the Year input for this Choreo. 

		@param Integer - (optional, integer) If a year is specified, only records for that year will be returned and the data in the company objects returned will be set appropriately for the request year. Defaults to most recent.
		*/
		public void set_Year(Integer value) {
			this.setInput("Year", value);
		}

		/** 
		Set the value of the Year input for this Choreo as a String. 

		@param String - (optional, integer) If a year is specified, only records for that year will be returned and the data in the company objects returned will be set appropriately for the request year. Defaults to most recent.
		*/
		public void set_Year(String value) {
			this.setInput("Year", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListLocations Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListLocationsResultSet extends ResultSet {
		public ListLocationsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from CorpWatch.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
