package com.temboo.Library.Clicky;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AdvancedFilter

Allows you to retrieve analytics, using more advanced filter options.
*/
public class AdvancedFilter extends Choreography {

	/**
	Create a new instance of the AdvancedFilter Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AdvancedFilter(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Clicky/AdvancedFilter"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AdvancedFilterInputSet
	*/
	public AdvancedFilterInputSet newInputSet() {
		return new AdvancedFilterInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AdvancedFilterResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AdvancedFilterResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AdvancedFilter
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AdvancedFilterInputSet extends InputSet {
		/** 
		Set the value of the Date input for this Choreo. 

		@param String - (optional, string) The date or date range you want to access. Use YYYY-MM-DD format for date and YYYY-MM-DD,YYYY-MM-DD for a range. See docs for more options for this input. Defaults to 'today'.
		*/
		public void set_Date(String value) {
			this.setInput("Date", value);
		}


		/** 
		Set the value of the FilterName input for this Choreo. 

		@param String - (required, string) The name of the data you want to filter by (i.e. ip_address). See docs for a complete list of supported filters.
		*/
		public void set_FilterName(String value) {
			this.setInput("FilterName", value);
		}


		/** 
		Set the value of the FilterValue input for this Choreo. 

		@param String - (required, string) The value of the filter you want to apply to the request. For example, if your FilterName is "ip_address", you could use "65.0.0.0,85.0.0.0" in the FilterValue.
		*/
		public void set_FilterValue(String value) {
			this.setInput("FilterValue", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The maximum number of results that will be returned. Defaults to 10.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The maximum number of results that will be returned. Defaults to 10.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Output input for this Choreo. 

		@param String - (optional, string) What format you want the returned data to be in. Accepted values: xml, php, json, csv. Defaults to 'xml'.
		*/
		public void set_Output(String value) {
			this.setInput("Output", value);
		}


		/** 
		Set the value of the SiteID input for this Choreo. 

		@param Integer - (required, integer) Your request must include the site's ID that you want to access data from. Available from your site preferences page.
		*/
		public void set_SiteID(Integer value) {
			this.setInput("SiteID", value);
		}

		/** 
		Set the value of the SiteID input for this Choreo as a String. 

		@param String - (required, integer) Your request must include the site's ID that you want to access data from. Available from your site preferences page.
		*/
		public void set_SiteID(String value) {
			this.setInput("SiteID", value);	
		}
		/** 
		Set the value of the SiteKey input for this Choreo. 

		@param String - (required, string) The unique key assigned to you when you first register with Clicky. Available from your site preferences page.
		*/
		public void set_SiteKey(String value) {
			this.setInput("SiteKey", value);
		}


		/** 
		Set the value of the Type input for this Choreo. 

		@param String - (required, string) The type of data you want to retrieve. Note that not all types are available for this Choreo. Use types: visitors-list, segmentation, or actions-list.
		*/
		public void set_Type(String value) {
			this.setInput("Type", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AdvancedFilter Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AdvancedFilterResultSet extends ResultSet {
		public AdvancedFilterResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Clicky formatted as specified in the Output parameter. Default is XML.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
