package com.temboo.Library.AuthorizeNet.CustomerInformationManager;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetCustomerShippingAddress

Retrieves a customer shipping address for an existing customer profile.
*/
public class GetCustomerShippingAddress extends Choreography {

	/**
	Create a new instance of the GetCustomerShippingAddress Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetCustomerShippingAddress(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/AuthorizeNet/CustomerInformationManager/GetCustomerShippingAddress"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetCustomerShippingAddressInputSet
	*/
	public GetCustomerShippingAddressInputSet newInputSet() {
		return new GetCustomerShippingAddressInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetCustomerShippingAddressResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetCustomerShippingAddressResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetCustomerShippingAddress
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetCustomerShippingAddressInputSet extends InputSet {
		/** 
		Set the value of the APILoginId input for this Choreo. 

		@param String - (required, string) The API Login Id provided by Authorize.net when signing up for a developer account.
		*/
		public void set_APILoginId(String value) {
			this.setInput("APILoginId", value);
		}


		/** 
		Set the value of the CustomerAddressId input for this Choreo. 

		@param Integer - (required, integer) The id for the shipping profile you want to retrieve.
		*/
		public void set_CustomerAddressId(Integer value) {
			this.setInput("CustomerAddressId", value);
		}

		/** 
		Set the value of the CustomerAddressId input for this Choreo as a String. 

		@param String - (required, integer) The id for the shipping profile you want to retrieve.
		*/
		public void set_CustomerAddressId(String value) {
			this.setInput("CustomerAddressId", value);	
		}
		/** 
		Set the value of the CustomerProfileId input for this Choreo. 

		@param Integer - (required, integer) The id of the customer who's shipping address you want to return.
		*/
		public void set_CustomerProfileId(Integer value) {
			this.setInput("CustomerProfileId", value);
		}

		/** 
		Set the value of the CustomerProfileId input for this Choreo as a String. 

		@param String - (required, integer) The id of the customer who's shipping address you want to return.
		*/
		public void set_CustomerProfileId(String value) {
			this.setInput("CustomerProfileId", value);	
		}
		/** 
		Set the value of the Endpoint input for this Choreo. 

		@param String - (optional, string) Set to api.authorize.net when running in production. Defaults to apitest.authorize.net for sandbox testing.
		*/
		public void set_Endpoint(String value) {
			this.setInput("Endpoint", value);
		}


		/** 
		Set the value of the TransactionKey input for this Choreo. 

		@param String - (required, string) The TransactionKey provided by Authorize.net when signing up for a developer account.
		*/
		public void set_TransactionKey(String value) {
			this.setInput("TransactionKey", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetCustomerShippingAddress Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetCustomerShippingAddressResultSet extends ResultSet {
		public GetCustomerShippingAddressResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Authorize.net.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
