package com.temboo.Library.Amazon.S3;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
DeleteBucketCORS

Deletes the CORS (Cross-Origin Resource Sharing) configuration information set for the specified bucket.
*/
public class DeleteBucketCORS extends Choreography {

	/**
	Create a new instance of the DeleteBucketCORS Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public DeleteBucketCORS(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/S3/DeleteBucketCORS"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return DeleteBucketCORSInputSet
	*/
	public DeleteBucketCORSInputSet newInputSet() {
		return new DeleteBucketCORSInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public DeleteBucketCORSResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new DeleteBucketCORSResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the DeleteBucketCORS
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class DeleteBucketCORSInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the BucketName input for this Choreo. 

		@param String - (required, string) The name of the bucket that the CORS configuration should be removed from.
		*/
		public void set_BucketName(String value) {
			this.setInput("BucketName", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (required, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the DeleteBucketCORS Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class DeleteBucketCORSResultSet extends ResultSet {
		public DeleteBucketCORSResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Amazon. Note that for a successful exection, this API operation returns an empty 204 response.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
