package com.temboo.Library.Amazon.IAM;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ChangePassword

Allows the authenticating user to change their password.
*/
public class ChangePassword extends Choreography {

	/**
	Create a new instance of the ChangePassword Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ChangePassword(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/IAM/ChangePassword"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ChangePasswordInputSet
	*/
	public ChangePasswordInputSet newInputSet() {
		return new ChangePasswordInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ChangePasswordResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ChangePasswordResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ChangePassword
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ChangePasswordInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The user's Access Key ID.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The user's Secret Key ID.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the NewPassword input for this Choreo. 

		@param String - (required, string) The new password.
		*/
		public void set_NewPassword(String value) {
			this.setInput("NewPassword", value);
		}


		/** 
		Set the value of the OldPassword input for this Choreo. 

		@param String - (required, string) The old password.
		*/
		public void set_OldPassword(String value) {
			this.setInput("OldPassword", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ChangePassword Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ChangePasswordResultSet extends ResultSet {
		public ChangePasswordResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
