package com.temboo.Library.Amazon.DynamoDB;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateTable

Modifies the provisioned throughput settings, global secondary indexes, or DynamoDB Streams settings for a given table.
*/
public class UpdateTable extends Choreography {

	/**
	Create a new instance of the UpdateTable Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateTable(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/DynamoDB/UpdateTable"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateTableInputSet
	*/
	public UpdateTableInputSet newInputSet() {
		return new UpdateTableInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateTableResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateTableResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateTable
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateTableInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the AttributeDefinitions input for this Choreo. 

		@param String - (optional, json) An array of attributes that describe the key schema for the table and indexes.
		*/
		public void set_AttributeDefinitions(String value) {
			this.setInput("AttributeDefinitions", value);
		}


		/** 
		Set the value of the GlobalSecondaryIndexUpdates input for this Choreo. 

		@param String - (conditional, json) One or more global secondary indexes (the maximum is five) to be created on the table.
		*/
		public void set_GlobalSecondaryIndexUpdates(String value) {
			this.setInput("GlobalSecondaryIndexUpdates", value);
		}


		/** 
		Set the value of the ProvisionedThroughput input for this Choreo. 

		@param String - (conditional, json) Represents the provisioned throughput settings for a specified table or index.
		*/
		public void set_ProvisionedThroughput(String value) {
			this.setInput("ProvisionedThroughput", value);
		}


		/** 
		Set the value of the StreamSpecification input for this Choreo. 

		@param String - (conditional, json) The settings for DynamoDB Streams on the table.
		*/
		public void set_StreamSpecification(String value) {
			this.setInput("StreamSpecification", value);
		}


		/** 
		Set the value of the TableName input for this Choreo. 

		@param String - (required, string) The name of the table to create.
		*/
		public void set_TableName(String value) {
			this.setInput("TableName", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateTable Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateTableResultSet extends ResultSet {
		public UpdateTableResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
