package com.temboo.Library.eBay.Trading;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetFeedback

Retrieves the feedback left for a specified user or the summary feedback data for a specific order line item or item listing.
*/
public class GetFeedback extends Choreography {

	/**
	Create a new instance of the GetFeedback Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetFeedback(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/eBay/Trading/GetFeedback"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetFeedbackInputSet
	*/
	public GetFeedbackInputSet newInputSet() {
		return new GetFeedbackInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetFeedbackResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetFeedbackResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetFeedback
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetFeedbackInputSet extends InputSet {
		/** 
		Set the value of the CommentType input for this Choreo. 

		@param String - (optional, string) Returns feedback of a specified type. Valid values are: Positive, Neutral, Negative, Withdrawn, IndependentlyWithdrawn.
		*/
		public void set_CommentType(String value) {
			this.setInput("CommentType", value);
		}


		/** 
		Set the value of the DetailLevel input for this Choreo. 

		@param String - (optional, string) The response detail level. Valid values are: ReturnAll.
		*/
		public void set_DetailLevel(String value) {
			this.setInput("DetailLevel", value);
		}


		/** 
		Set the value of the EntriesPerPage input for this Choreo. 

		@param Integer - (optional, integer) The maximum number of records to return in the result.
		*/
		public void set_EntriesPerPage(Integer value) {
			this.setInput("EntriesPerPage", value);
		}

		/** 
		Set the value of the EntriesPerPage input for this Choreo as a String. 

		@param String - (optional, integer) The maximum number of records to return in the result.
		*/
		public void set_EntriesPerPage(String value) {
			this.setInput("EntriesPerPage", value);	
		}
		/** 
		Set the value of the FeedbackID input for this Choreo. 

		@param String - (optional, string) An ID that uniquely identifies a feedback record to be retrieved
		*/
		public void set_FeedbackID(String value) {
			this.setInput("FeedbackID", value);
		}


		/** 
		Set the value of the FeedbackType input for this Choreo. 

		@param String - (optional, string) The type of feedback to return. Valid values are: FeedbackReceivedAsSeller, FeedbackReceivedAsBuyer, FeedbackReceived, FeedbackLeft, CustomCode.
		*/
		public void set_FeedbackType(String value) {
			this.setInput("FeedbackType", value);
		}


		/** 
		Set the value of the ItemID input for this Choreo. 

		@param String - (optional, string) The unique identifier for an eBay item listing.
		*/
		public void set_ItemID(String value) {
			this.setInput("ItemID", value);
		}


		/** 
		Set the value of the OrderLineItemID input for this Choreo. 

		@param String - (optional, string) The unique identifier for an eBay order line item. This id generated by concatenating ItemID and TransactionID with a hyphen in between the IDs.
		*/
		public void set_OrderLineItemID(String value) {
			this.setInput("OrderLineItemID", value);
		}


		/** 
		Set the value of the PageNumber input for this Choreo. 

		@param Integer - (optional, integer) Specifies the page number of the results to return.
		*/
		public void set_PageNumber(Integer value) {
			this.setInput("PageNumber", value);
		}

		/** 
		Set the value of the PageNumber input for this Choreo as a String. 

		@param String - (optional, integer) Specifies the page number of the results to return.
		*/
		public void set_PageNumber(String value) {
			this.setInput("PageNumber", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SandboxMode input for this Choreo. 

		@param Boolean - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(Boolean value) {
			this.setInput("SandboxMode", value);
		}

		/** 
		Set the value of the SandboxMode input for this Choreo as a String. 

		@param String - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(String value) {
			this.setInput("SandboxMode", value);	
		}
		/** 
		Set the value of the SiteID input for this Choreo. 

		@param String - (optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
		*/
		public void set_SiteID(String value) {
			this.setInput("SiteID", value);
		}


		/** 
		Set the value of the TransactionID input for this Choreo. 

		@param String - (optional, string) The unique identifier for an eBay order line item (transaction).
		*/
		public void set_TransactionID(String value) {
			this.setInput("TransactionID", value);
		}


		/** 
		Set the value of the UserID input for this Choreo. 

		@param String - (conditional, string) The seller's UserID.
		*/
		public void set_UserID(String value) {
			this.setInput("UserID", value);
		}


		/** 
		Set the value of the UserToken input for this Choreo. 

		@param String - (required, string) A valid eBay Auth Token.
		*/
		public void set_UserToken(String value) {
			this.setInput("UserToken", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetFeedback Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetFeedbackResultSet extends ResultSet {
		public GetFeedbackResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from eBay.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
