package com.temboo.Library.eBay.Trading;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AddMemberMessageRTQ

Allows a seller to reply to a question about an active item listing.
*/
public class AddMemberMessageRTQ extends Choreography {

	/**
	Create a new instance of the AddMemberMessageRTQ Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AddMemberMessageRTQ(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/eBay/Trading/AddMemberMessageRTQ"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AddMemberMessageRTQInputSet
	*/
	public AddMemberMessageRTQInputSet newInputSet() {
		return new AddMemberMessageRTQInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AddMemberMessageRTQResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AddMemberMessageRTQResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AddMemberMessageRTQ
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AddMemberMessageRTQInputSet extends InputSet {
		/** 
		Set the value of the Body input for this Choreo. 

		@param String - (required, string) The message body which should answer the question that an eBay user ask the seller. HTML is not allowed.
		*/
		public void set_Body(String value) {
			this.setInput("Body", value);
		}


		/** 
		Set the value of the DisplayToPublic input for this Choreo. 

		@param String - (optional, string) When set to true, this indicates that the member message is viewable in the item listing.
		*/
		public void set_DisplayToPublic(String value) {
			this.setInput("DisplayToPublic", value);
		}


		/** 
		Set the value of the EmailCopyToSender input for this Choreo. 

		@param Boolean - (optional, boolean) A flag used to indicate that a copy should be sent to the sender.
		*/
		public void set_EmailCopyToSender(Boolean value) {
			this.setInput("EmailCopyToSender", value);
		}

		/** 
		Set the value of the EmailCopyToSender input for this Choreo as a String. 

		@param String - (optional, boolean) A flag used to indicate that a copy should be sent to the sender.
		*/
		public void set_EmailCopyToSender(String value) {
			this.setInput("EmailCopyToSender", value);	
		}
		/** 
		Set the value of the ItemID input for this Choreo. 

		@param String - (optional, string) The unique ID of the item about which the question was asked.
		*/
		public void set_ItemID(String value) {
			this.setInput("ItemID", value);
		}


		/** 
		Set the value of the ParentMessageID input for this Choreo. 

		@param String - (required, string) The ID number of the question to which this message is responding.
		*/
		public void set_ParentMessageID(String value) {
			this.setInput("ParentMessageID", value);
		}


		/** 
		Set the value of the RecipientID input for this Choreo. 

		@param String - (required, string) The recipient's eBay user ID.
		*/
		public void set_RecipientID(String value) {
			this.setInput("RecipientID", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SandboxMode input for this Choreo. 

		@param Boolean - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(Boolean value) {
			this.setInput("SandboxMode", value);
		}

		/** 
		Set the value of the SandboxMode input for this Choreo as a String. 

		@param String - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(String value) {
			this.setInput("SandboxMode", value);	
		}
		/** 
		Set the value of the SiteID input for this Choreo. 

		@param String - (optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
		*/
		public void set_SiteID(String value) {
			this.setInput("SiteID", value);
		}


		/** 
		Set the value of the UserToken input for this Choreo. 

		@param String - (required, string) A valid eBay Auth Token.
		*/
		public void set_UserToken(String value) {
			this.setInput("UserToken", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AddMemberMessageRTQ Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AddMemberMessageRTQResultSet extends ResultSet {
		public AddMemberMessageRTQResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from eBay.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
