package com.temboo.Library.Xively.Triggers;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ReadTrigger

Returns a specific trigger for the authenticated account.
*/
public class ReadTrigger extends Choreography {

	/**
	Create a new instance of the ReadTrigger Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ReadTrigger(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Xively/Triggers/ReadTrigger"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ReadTriggerInputSet
	*/
	public ReadTriggerInputSet newInputSet() {
		return new ReadTriggerInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ReadTriggerResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ReadTriggerResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ReadTrigger
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ReadTriggerInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Xively.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "json" (the default) and "xml".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the TriggerID input for this Choreo. 

		@param Integer - (required, integer) ID for the trigger that you wish to retrieve information about.
		*/
		public void set_TriggerID(Integer value) {
			this.setInput("TriggerID", value);
		}

		/** 
		Set the value of the TriggerID input for this Choreo as a String. 

		@param String - (required, integer) ID for the trigger that you wish to retrieve information about.
		*/
		public void set_TriggerID(String value) {
			this.setInput("TriggerID", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ReadTrigger Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ReadTriggerResultSet extends ResultSet {
		public ReadTriggerResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Xively.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
