package com.temboo.Library.Xively.ReadWriteData;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ReadFeed

Returns filterable data on a specific feed viewable by the authenticated account.
*/
public class ReadFeed extends Choreography {

	/**
	Create a new instance of the ReadFeed Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ReadFeed(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Xively/ReadWriteData/ReadFeed"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ReadFeedInputSet
	*/
	public ReadFeedInputSet newInputSet() {
		return new ReadFeedInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ReadFeedResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ReadFeedResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ReadFeed
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ReadFeedInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Xively.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Datastreams input for this Choreo. 

		@param String - (optional, string) Filter by datastream. Valid values - comma separated datastream IDs (Ex: energy,power).
		*/
		public void set_Datastreams(String value) {
			this.setInput("Datastreams", value);
		}


		/** 
		Set the value of the Duration input for this Choreo. 

		@param String - (optional, string) Used for a historical query. If used with EndDate will request data prior to EndDate, if used with StartDate will request data after StartDate. By itself will give most recent data. Ex: 6hours, 2days.
		*/
		public void set_Duration(String value) {
			this.setInput("Duration", value);
		}


		/** 
		Set the value of the EndDate input for this Choreo. 

		@param String - (optional, date) Used for a historical query. Defines the end point of the data returned as a timestamp. Ex: 2013-05-10T12:00:00Z.
		*/
		public void set_EndDate(String value) {
			this.setInput("EndDate", value);
		}


		/** 
		Set the value of the FeedID input for this Choreo. 

		@param Integer - (required, integer) The ID of the feed you wish to view.
		*/
		public void set_FeedID(Integer value) {
			this.setInput("FeedID", value);
		}

		/** 
		Set the value of the FeedID input for this Choreo as a String. 

		@param String - (required, integer) The ID of the feed you wish to view.
		*/
		public void set_FeedID(String value) {
			this.setInput("FeedID", value);	
		}
		/** 
		Set the value of the FeedType input for this Choreo. 

		@param String - (optional, string) The type of feed that is being returned. Valid values are "json" (the default), "csv" and "xml". No metadata is returned for the csv feed.
		*/
		public void set_FeedType(String value) {
			this.setInput("FeedType", value);
		}


		/** 
		Set the value of the FindPrevious input for this Choreo. 

		@param Boolean - (optional, boolean) Used for a historical query. Will also return the previous value to the date range being requested. Useful when graphing, to start a graph with a datapoint. Valid values: "true", blank (default).
		*/
		public void set_FindPrevious(Boolean value) {
			this.setInput("FindPrevious", value);
		}

		/** 
		Set the value of the FindPrevious input for this Choreo as a String. 

		@param String - (optional, boolean) Used for a historical query. Will also return the previous value to the date range being requested. Useful when graphing, to start a graph with a datapoint. Valid values: "true", blank (default).
		*/
		public void set_FindPrevious(String value) {
			this.setInput("FindPrevious", value);	
		}
		/** 
		Set the value of the Interval input for this Choreo. 

		@param Integer - (optional, integer) Used for a historical query. Determines what interval of data is requested and is defined in seconds between the datapoints. See documentation for full list of possible values. Ex.: 0, 30, 60, etc.
		*/
		public void set_Interval(Integer value) {
			this.setInput("Interval", value);
		}

		/** 
		Set the value of the Interval input for this Choreo as a String. 

		@param String - (optional, integer) Used for a historical query. Determines what interval of data is requested and is defined in seconds between the datapoints. See documentation for full list of possible values. Ex.: 0, 30, 60, etc.
		*/
		public void set_Interval(String value) {
			this.setInput("Interval", value);	
		}
		/** 
		Set the value of the IntervalType input for this Choreo. 

		@param String - (optional, string) Used for a historical query. If set to "discrete" the data will be returned in fixed time interval format according to Interval value. If not set, the raw datapoints will be returned.
		*/
		public void set_IntervalType(String value) {
			this.setInput("IntervalType", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) Used for a historical query. Limits the number of results to the number specified here. Defaults to 100, has a maximum of 1000.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) Used for a historical query. Limits the number of results to the number specified here. Defaults to 100, has a maximum of 1000.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the ShowUser input for this Choreo. 

		@param String - (optional, string) Include user login for each feed. For JSON/XML response only. Valid values: "true", "false" (default).
		*/
		public void set_ShowUser(String value) {
			this.setInput("ShowUser", value);
		}


		/** 
		Set the value of the StartDate input for this Choreo. 

		@param String - (optional, date) Used for a historical query. Defines the starting point of the query as a timestamp. Ex: 2013-05-10T00:00:00Z.
		*/
		public void set_StartDate(String value) {
			this.setInput("StartDate", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ReadFeed Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ReadFeedResultSet extends ResultSet {
		public ReadFeedResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Xively.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
