package com.temboo.Library.Xively.APIKeys;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
RegenerateKey

Allows you to regenerate a new key with the same attributes and permissions as a previous key.
*/
public class RegenerateKey extends Choreography {

	/**
	Create a new instance of the RegenerateKey Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public RegenerateKey(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Xively/APIKeys/RegenerateKey"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return RegenerateKeyInputSet
	*/
	public RegenerateKeyInputSet newInputSet() {
		return new RegenerateKeyInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public RegenerateKeyResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new RegenerateKeyResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the RegenerateKey
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class RegenerateKeyInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key you would like to regenerate. On successful regeneration, this API Key will no longer be valid.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the MasterAPIKey input for this Choreo. 

		@param String - (optional, string) Specify a MasterAPIKey with sufficient permissions if the APIKey you would like to regenerate does not have the permissions to do so.
		*/
		public void set_MasterAPIKey(String value) {
			this.setInput("MasterAPIKey", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the RegenerateKey Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class RegenerateKeyResultSet extends ResultSet {
		public RegenerateKeyResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "APIKeyLocation" output from this Choreo execution

		@return String - (string) The URL of the newly regenerated APIKey.
		*/
		public String get_APIKeyLocation() {
			return this.getResultString("APIKeyLocation");
		}
		/** 
		Retrieve the value for the "NewAPIKey" output from this Choreo execution

		@return String - (string) The regenerated APIKey obtained from the APIKeyLocation returned by this Choreo.
		*/
		public String get_NewAPIKey() {
			return this.getResultString("NewAPIKey");
		}
	}
	
}
