package com.temboo.Library.Utilities.Text;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SubstituteRegex

Finds all instances of the specified regular expression pattern within the given string and passes the specified new sub-string to the result variable. 
*/
public class SubstituteRegex extends Choreography {

	/**
	Create a new instance of the SubstituteRegex Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SubstituteRegex(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/Text/SubstituteRegex"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SubstituteRegexInputSet
	*/
	public SubstituteRegexInputSet newInputSet() {
		return new SubstituteRegexInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SubstituteRegexResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SubstituteRegexResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SubstituteRegex
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SubstituteRegexInputSet extends InputSet {
		/** 
		Set the value of the New input for this Choreo. 

		@param String - (required, string) New sub-string to replace with.
		*/
		public void set_New(String value) {
			this.setInput("New", value);
		}


		/** 
		Set the value of the Pattern input for this Choreo. 

		@param String - (required, string) Regex pattern to use.
		*/
		public void set_Pattern(String value) {
			this.setInput("Pattern", value);
		}


		/** 
		Set the value of the Text input for this Choreo. 

		@param String - (required, string) Text to peform substitution.
		*/
		public void set_Text(String value) {
			this.setInput("Text", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SubstituteRegex Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SubstituteRegexResultSet extends ResultSet {
		public SubstituteRegexResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (string) The result after the substitution.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
