package com.temboo.Library.Utilities.Hashing;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
HmacSHA256

Generates a SHA256-encrypted HMAC signature for the specified message text using the specified secret key.
*/
public class HmacSHA256 extends Choreography {

	/**
	Create a new instance of the HmacSHA256 Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public HmacSHA256(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/Hashing/HmacSHA256"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return HmacSHA256InputSet
	*/
	public HmacSHA256InputSet newInputSet() {
		return new HmacSHA256InputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public HmacSHA256ResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new HmacSHA256ResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the HmacSHA256
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class HmacSHA256InputSet extends InputSet {
		/** 
		Set the value of the Key input for this Choreo. 

		@param String - (required, string) The secret key used to generate the SHA256-encrypted HMAC signature.
		*/
		public void set_Key(String value) {
			this.setInput("Key", value);
		}


		/** 
		Set the value of the Text input for this Choreo. 

		@param String - (required, string) The text that should be SHA256-encrypted.
		*/
		public void set_Text(String value) {
			this.setInput("Text", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the HmacSHA256 Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class HmacSHA256ResultSet extends ResultSet {
		public HmacSHA256ResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "HmacSignature" output from this Choreo execution

		@return String - (string) The HMAC Signature for the specified string.
		*/
		public String get_HmacSignature() {
			return this.getResultString("HmacSignature");
		}
	}
	
}
