package com.temboo.Library.Twitter.DirectMessages;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SendDirectMessage

Sends a new direct message to the specified user from the authenticating user.
*/
public class SendDirectMessage extends Choreography {

	/**
	Create a new instance of the SendDirectMessage Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SendDirectMessage(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Twitter/DirectMessages/SendDirectMessage"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SendDirectMessageInputSet
	*/
	public SendDirectMessageInputSet newInputSet() {
		return new SendDirectMessageInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SendDirectMessageResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SendDirectMessageResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SendDirectMessage
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SendDirectMessageInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the ConsumerKey input for this Choreo. 

		@param String - (required, string) The API Key (or Consumer Key) provided by Twitter.
		*/
		public void set_ConsumerKey(String value) {
			this.setInput("ConsumerKey", value);
		}


		/** 
		Set the value of the ConsumerSecret input for this Choreo. 

		@param String - (required, string) The API Secret (or Consumer Secret) provided by Twitter.
		*/
		public void set_ConsumerSecret(String value) {
			this.setInput("ConsumerSecret", value);
		}


		/** 
		Set the value of the ScreenName input for this Choreo. 

		@param String - (conditional, string) The screen name of the user who should receive the direct message. Required unless specifying the UserId.
		*/
		public void set_ScreenName(String value) {
			this.setInput("ScreenName", value);
		}


		/** 
		Set the value of the Text input for this Choreo. 

		@param String - (required, string) The text for the direct message. Max characters is 140.
		*/
		public void set_Text(String value) {
			this.setInput("Text", value);
		}


		/** 
		Set the value of the UserID input for this Choreo. 

		@param String - (conditional, string) The ID of the user who should receive the direct message. Required unless specifying the ScreenName.
		*/
		public void set_UserID(String value) {
			this.setInput("UserID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SendDirectMessage Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SendDirectMessageResultSet extends ResultSet {
		public SendDirectMessageResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Twitter.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
