package com.temboo.Library.SunlightLabs.Congress.Legislator;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetList

Returns a list of legislators that meet a specified search criteria.
*/
public class GetList extends Choreography {

	/**
	Create a new instance of the GetList Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetList(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/SunlightLabs/Congress/Legislator/GetList"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetListInputSet
	*/
	public GetListInputSet newInputSet() {
		return new GetListInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetListResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetListResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetList
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetListInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Sunlight Labs.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the AllLegislators input for this Choreo. 

		@param Boolean - (optional, boolean) A boolean flag indicating to search for all legislators even when they are no longer in office.
		*/
		public void set_AllLegislators(Boolean value) {
			this.setInput("AllLegislators", value);
		}

		/** 
		Set the value of the AllLegislators input for this Choreo as a String. 

		@param String - (optional, boolean) A boolean flag indicating to search for all legislators even when they are no longer in office.
		*/
		public void set_AllLegislators(String value) {
			this.setInput("AllLegislators", value);	
		}
		/** 
		Set the value of the BioguideID input for this Choreo. 

		@param String - (optional, string) The bioguide_id of the legislator to return.
		*/
		public void set_BioguideID(String value) {
			this.setInput("BioguideID", value);
		}


		/** 
		Set the value of the CRPID input for this Choreo. 

		@param String - (optional, string) The crp_id associated with a legislator to return.
		*/
		public void set_CRPID(String value) {
			this.setInput("CRPID", value);
		}


		/** 
		Set the value of the District input for this Choreo. 

		@param Integer - (optional, integer) Narrows the search result by district number.
		*/
		public void set_District(Integer value) {
			this.setInput("District", value);
		}

		/** 
		Set the value of the District input for this Choreo as a String. 

		@param String - (optional, integer) Narrows the search result by district number.
		*/
		public void set_District(String value) {
			this.setInput("District", value);	
		}
		/** 
		Set the value of the FECID input for this Choreo. 

		@param String - (optional, string) The fec_id associated with the legislator to return.
		*/
		public void set_FECID(String value) {
			this.setInput("FECID", value);
		}


		/** 
		Set the value of the FacebookID input for this Choreo. 

		@param String - (optional, string) The facebook id of a legislator to return.
		*/
		public void set_FacebookID(String value) {
			this.setInput("FacebookID", value);
		}


		/** 
		Set the value of the Filters input for this Choreo. 

		@param String - (optional, json) A JSON object containing key/value pairs to be used as filters.
		*/
		public void set_Filters(String value) {
			this.setInput("Filters", value);
		}


		/** 
		Set the value of the FirstName input for this Choreo. 

		@param String - (optional, string) The first name of a legislator to return.
		*/
		public void set_FirstName(String value) {
			this.setInput("FirstName", value);
		}


		/** 
		Set the value of the Gender input for this Choreo. 

		@param String - (optional, string) Narrows the search result by gender.
		*/
		public void set_Gender(String value) {
			this.setInput("Gender", value);
		}


		/** 
		Set the value of the GovTrackID input for this Choreo. 

		@param String - (optional, string) The govetrack_id associated with a legistlator to return.
		*/
		public void set_GovTrackID(String value) {
			this.setInput("GovTrackID", value);
		}


		/** 
		Set the value of the InOffice input for this Choreo. 

		@param Boolean - (optional, boolean) Whether or not the individual is in office currently. Valid values are true or false.
		*/
		public void set_InOffice(Boolean value) {
			this.setInput("InOffice", value);
		}

		/** 
		Set the value of the InOffice input for this Choreo as a String. 

		@param String - (optional, boolean) Whether or not the individual is in office currently. Valid values are true or false.
		*/
		public void set_InOffice(String value) {
			this.setInput("InOffice", value);	
		}
		/** 
		Set the value of the LastName input for this Choreo. 

		@param String - (optional, string) The last name of the legislator to return.
		*/
		public void set_LastName(String value) {
			this.setInput("LastName", value);
		}


		/** 
		Set the value of the Order input for this Choreo. 

		@param String - (optional, string) Used to order the results by field name (e.g. field__asc).
		*/
		public void set_Order(String value) {
			this.setInput("Order", value);
		}


		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) The page offset.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) The page offset.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the Party input for this Choreo. 

		@param String - (optional, string) Narrows the search result by party (i.e. "D" or "R").
		*/
		public void set_Party(String value) {
			this.setInput("Party", value);
		}


		/** 
		Set the value of the PerPage input for this Choreo. 

		@param Integer - (optional, integer) The number of results to return per page.
		*/
		public void set_PerPage(Integer value) {
			this.setInput("PerPage", value);
		}

		/** 
		Set the value of the PerPage input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to return per page.
		*/
		public void set_PerPage(String value) {
			this.setInput("PerPage", value);	
		}
		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (optional, string) A search term.
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the State input for this Choreo. 

		@param String - (optional, string) A state abbreviation to narrow the search results.
		*/
		public void set_State(String value) {
			this.setInput("State", value);
		}


		/** 
		Set the value of the Title input for this Choreo. 

		@param String - (optional, string) The title associated with the individual to return.
		*/
		public void set_Title(String value) {
			this.setInput("Title", value);
		}


		/** 
		Set the value of the TwitterID input for this Choreo. 

		@param String - (optional, string) The twitter id of the legislator to return (note, this can be a twitter screen name).
		*/
		public void set_TwitterID(String value) {
			this.setInput("TwitterID", value);
		}


		/** 
		Set the value of the VoteSmartID input for this Choreo. 

		@param Integer - (optional, integer) The votesmart_id of a legislator to return.
		*/
		public void set_VoteSmartID(Integer value) {
			this.setInput("VoteSmartID", value);
		}

		/** 
		Set the value of the VoteSmartID input for this Choreo as a String. 

		@param String - (optional, integer) The votesmart_id of a legislator to return.
		*/
		public void set_VoteSmartID(String value) {
			this.setInput("VoteSmartID", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetList Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetListResultSet extends ResultSet {
		public GetListResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from the Sunlight Congress API.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
