package com.temboo.Library.RunKeeper.BackgroundActivities;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
DeleteActivity

Removes an individual background activity from a user’s feed.
*/
public class DeleteActivity extends Choreography {

	/**
	Create a new instance of the DeleteActivity Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public DeleteActivity(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/RunKeeper/BackgroundActivities/DeleteActivity"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return DeleteActivityInputSet
	*/
	public DeleteActivityInputSet newInputSet() {
		return new DeleteActivityInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public DeleteActivityResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new DeleteActivityResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the DeleteActivity
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class DeleteActivityInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved after the final step in the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ActivityID input for this Choreo. 

		@param String - (required, string) This can be the individual id of the activity, or you can pass the full uri for the activity as returned from the RetrieveActivities Choreo (i.e. /backgroundActivities/-12985593-1347998400000).
		*/
		public void set_ActivityID(String value) {
			this.setInput("ActivityID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the DeleteActivity Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class DeleteActivityResultSet extends ResultSet {
		public DeleteActivityResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (boolean) Contains the string "true" when activities are successfully deleted.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
