package com.temboo.Library.Pusher.Channels;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetChannel

Retrieves information for a specific channel.
*/
public class GetChannel extends Choreography {

	/**
	Create a new instance of the GetChannel Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetChannel(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Pusher/Channels/GetChannel"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetChannelInputSet
	*/
	public GetChannelInputSet newInputSet() {
		return new GetChannelInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetChannelResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetChannelResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetChannel
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetChannelInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (required, string) The application ID provided by Pusher.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the AppKey input for this Choreo. 

		@param String - (required, string) The authenticaion key provided by Pusher.
		*/
		public void set_AppKey(String value) {
			this.setInput("AppKey", value);
		}


		/** 
		Set the value of the AppSecret input for this Choreo. 

		@param String - (required, string) The authentication secret provided by Pusher.
		*/
		public void set_AppSecret(String value) {
			this.setInput("AppSecret", value);
		}


		/** 
		Set the value of the ChannelName input for this Choreo. 

		@param String - (required, string) The name of the channel to retrieve.
		*/
		public void set_ChannelName(String value) {
			this.setInput("ChannelName", value);
		}


		/** 
		Set the value of the Info input for this Choreo. 

		@param String - (optional, string) A comma separated list of attributes which should be returned for the channel (e.g., user_count, subscription_count). Note that the user_count attribute is only applicable for presence channels.
		*/
		public void set_Info(String value) {
			this.setInput("Info", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetChannel Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetChannelResultSet extends ResultSet {
		public GetChannelResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Pusher.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
