package com.temboo.Library.Plotly;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ConfigureGraph

Creates, modifies, or styles a graph.
*/
public class ConfigureGraph extends Choreography {

	/**
	Create a new instance of the ConfigureGraph Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ConfigureGraph(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Plotly/ConfigureGraph"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ConfigureGraphInputSet
	*/
	public ConfigureGraphInputSet newInputSet() {
		return new ConfigureGraphInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ConfigureGraphResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ConfigureGraphResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ConfigureGraph
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ConfigureGraphInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Plotly.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the FileName input for this Choreo. 

		@param String - (required, string) The file name of your Plotly graph. If the file is nested within a directory, you can specify a path here (e.g., myFolder/myPlot).
		*/
		public void set_FileName(String value) {
			this.setInput("FileName", value);
		}


		/** 
		Set the value of the FileOption input for this Choreo. 

		@param String - (required, string) The file operation being performed. Valid values are: "new", "overwrite", "append", or "extend". See Choreo description for more details.
		*/
		public void set_FileOption(String value) {
			this.setInput("FileOption", value);
		}


		/** 
		Set the value of the GraphArguments input for this Choreo. 

		@param String - (conditional, json) The data and/or styling arguments. Typically, this is in the form of a JSON array where x and y are represented as arrays of numbers or strings. See Choreo description for more details.
		*/
		public void set_GraphArguments(String value) {
			this.setInput("GraphArguments", value);
		}


		/** 
		Set the value of the Layout input for this Choreo. 

		@param String - (optional, json) A key-value paired JSON object that describes the layout of the plot (e.g., {"title": "Sensor Data"}).
		*/
		public void set_Layout(String value) {
			this.setInput("Layout", value);
		}


		/** 
		Set the value of the Origin input for this Choreo. 

		@param String - (optional, string) Specifies the type of call and the type of data in the Arguments parameter. Valid values are: plot (the default), style, or layout.
		*/
		public void set_Origin(String value) {
			this.setInput("Origin", value);
		}


		/** 
		Set the value of the Style input for this Choreo. 

		@param String - (optional, json) A JSON object describing the style of the graph (e.g., {"type": "bar"}). This can be applied to every single trace (default) or to the traces specified in the optional Traces input.
		*/
		public void set_Style(String value) {
			this.setInput("Style", value);
		}


		/** 
		Set the value of the Traces input for this Choreo. 

		@param String - (optional, json) Specifies the indices that the Style input object should be applied to. This should be formatted as a JSON array.
		*/
		public void set_Traces(String value) {
			this.setInput("Traces", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) A valid Plotly username.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


		/** 
		Set the value of the WorldReadable input for this Choreo. 

		@param Boolean - (optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.
		*/
		public void set_WorldReadable(Boolean value) {
			this.setInput("WorldReadable", value);
		}

		/** 
		Set the value of the WorldReadable input for this Choreo as a String. 

		@param String - (optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.
		*/
		public void set_WorldReadable(String value) {
			this.setInput("WorldReadable", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ConfigureGraph Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ConfigureGraphResultSet extends ResultSet {
		public ConfigureGraphResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "URL" output from this Choreo execution

		@return String - (string) The Plotly URL for the graph.
		*/
		public String get_URL() {
			return this.getResultString("URL");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Plotly
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
