package com.temboo.Library.PayPal.Payments;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ExecutePayment

Executes a PayPal payment that has been accepted and approved.
*/
public class ExecutePayment extends Choreography {

	/**
	Create a new instance of the ExecutePayment Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ExecutePayment(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/PayPal/Payments/ExecutePayment"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ExecutePaymentInputSet
	*/
	public ExecutePaymentInputSet newInputSet() {
		return new ExecutePaymentInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ExecutePaymentResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ExecutePaymentResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ExecutePayment
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ExecutePaymentInputSet extends InputSet {
		/** 
		Set the value of the PayerID input for this Choreo. 

		@param String - (required, string) The id of the user who is making a payment.
		*/
		public void set_PayerID(String value) {
			this.setInput("PayerID", value);
		}


		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid access token retrieved from PayPal. Required unless providing the ClientID and ClientSecret which can be used to generate a new access token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by PayPal. Required unless a valid Access Token is provided.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by PayPal. Required unless a valid Access Token is provided.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the PaymentID input for this Choreo. 

		@param String - (required, string) The id of the payment to execute.
		*/
		public void set_PaymentID(String value) {
			this.setInput("PaymentID", value);
		}


		/** 
		Set the value of the Scope input for this Choreo. 

		@param String - (optional, string) A space delimited list of resource URL endpoints that the token should have access for. This is only used when providing the ClientID and Client Secret in order to generate a new access token.
		*/
		public void set_Scope(String value) {
			this.setInput("Scope", value);
		}


		/** 
		Set the value of the UseSandbox input for this Choreo. 

		@param Boolean - (conditional, boolean) Set to 1 to indicate that you're testing against the PayPal sandbox instead of production. Set to 0 (the default) when moving to production.
		*/
		public void set_UseSandbox(Boolean value) {
			this.setInput("UseSandbox", value);
		}

		/** 
		Set the value of the UseSandbox input for this Choreo as a String. 

		@param String - (conditional, boolean) Set to 1 to indicate that you're testing against the PayPal sandbox instead of production. Set to 0 (the default) when moving to production.
		*/
		public void set_UseSandbox(String value) {
			this.setInput("UseSandbox", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ExecutePayment Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ExecutePaymentResultSet extends ResultSet {
		public ExecutePaymentResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) The new access token retrieved from PayPal when providing the Client ID and Client Secret.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "SaleID" output from this Choreo execution

		@return String - (string) The id of the sale that was just executed. This can be used to Lookup the sales transaction if needed.
		*/
		public String get_SaleID() {
			return this.getResultString("SaleID");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from PayPal.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
