package com.temboo.Library.OneLogin.Events;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateEvent

Creates a new event.
*/
public class CreateEvent extends Choreography {

	/**
	Create a new instance of the CreateEvent Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateEvent(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/OneLogin/Events/CreateEvent"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateEventInputSet
	*/
	public CreateEventInputSet newInputSet() {
		return new CreateEventInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateEventResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateEventResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateEvent
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateEventInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by OneLogin.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the EventTypeID input for this Choreo. 

		@param Integer - (required, integer) The id for the type of event you want to create. Note that depending on the event type id specified, you may need to provide the ObjectName and ObjectID that is being affected.
		*/
		public void set_EventTypeID(Integer value) {
			this.setInput("EventTypeID", value);
		}

		/** 
		Set the value of the EventTypeID input for this Choreo as a String. 

		@param String - (required, integer) The id for the type of event you want to create. Note that depending on the event type id specified, you may need to provide the ObjectName and ObjectID that is being affected.
		*/
		public void set_EventTypeID(String value) {
			this.setInput("EventTypeID", value);	
		}
		/** 
		Set the value of the ObjectID input for this Choreo. 

		@param Integer - (conditional, integer) The object id that is being affected. Required for certain event types. When specified, ObjectName must also be provided.
		*/
		public void set_ObjectID(Integer value) {
			this.setInput("ObjectID", value);
		}

		/** 
		Set the value of the ObjectID input for this Choreo as a String. 

		@param String - (conditional, integer) The object id that is being affected. Required for certain event types. When specified, ObjectName must also be provided.
		*/
		public void set_ObjectID(String value) {
			this.setInput("ObjectID", value);	
		}
		/** 
		Set the value of the ObjectName input for this Choreo. 

		@param String - (conditional, string) The object name that is being affected (i.e. user-id). Required for certain event types. When specified, ObjectID must also be provided.
		*/
		public void set_ObjectName(String value) {
			this.setInput("ObjectName", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateEvent Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateEventResultSet extends ResultSet {
		public CreateEventResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from OneLogin.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
