package com.temboo.Library.NYTimes.BestSellers;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetBestSellerList

Retrieves data from a New York Times best-seller list for a specified date.
*/
public class GetBestSellerList extends Choreography {

	/**
	Create a new instance of the GetBestSellerList Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetBestSellerList(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/NYTimes/BestSellers/GetBestSellerList"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetBestSellerListInputSet
	*/
	public GetBestSellerListInputSet newInputSet() {
		return new GetBestSellerListInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetBestSellerListResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetBestSellerListResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetBestSellerList
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetBestSellerListInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by NY Times.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Date input for this Choreo. 

		@param String - (required, date) The best-seller list publication date in YYYY-MM-DD format.
		*/
		public void set_Date(String value) {
			this.setInput("Date", value);
		}


		/** 
		Set the value of the ListName input for this Choreo. 

		@param String - (required, string) The Times best-seller list to retrieve (i.e. e-book-fiction or hardcover-fiction).
		*/
		public void set_ListName(String value) {
			this.setInput("ListName", value);
		}


		/** 
		Set the value of the Offset input for this Choreo. 

		@param Integer - (optional, integer) The first 20 results are shown by default. To page through the results, set Offset to the appropriate value.
		*/
		public void set_Offset(Integer value) {
			this.setInput("Offset", value);
		}

		/** 
		Set the value of the Offset input for this Choreo as a String. 

		@param String - (optional, integer) The first 20 results are shown by default. To page through the results, set Offset to the appropriate value.
		*/
		public void set_Offset(String value) {
			this.setInput("Offset", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SortBy input for this Choreo. 

		@param String - (optional, string) The column name to sort by. Valid values are: bestsellers-date, date, isbn, list, list-name, published-date, rank, rank-last-week, and weeks-on-list.
		*/
		public void set_SortBy(String value) {
			this.setInput("SortBy", value);
		}


		/** 
		Set the value of the SortOrder input for this Choreo. 

		@param String - (optional, string) The sort order. Valid values are: ASC and DESC.
		*/
		public void set_SortOrder(String value) {
			this.setInput("SortOrder", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetBestSellerList Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetBestSellerListResultSet extends ResultSet {
		public GetBestSellerListResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from the NY Times API.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
