package com.temboo.Library.NOAA;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListCoordinatesForZipcode

Retrieve latitude and longitude data for a specified zipcode (in 50 U.S. States and Puerto Rico).
*/
public class ListCoordinatesForZipcode extends Choreography {

	/**
	Create a new instance of the ListCoordinatesForZipcode Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListCoordinatesForZipcode(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/NOAA/ListCoordinatesForZipcode"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListCoordinatesForZipcodeInputSet
	*/
	public ListCoordinatesForZipcodeInputSet newInputSet() {
		return new ListCoordinatesForZipcodeInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListCoordinatesForZipcodeResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListCoordinatesForZipcodeResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListCoordinatesForZipcode
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListCoordinatesForZipcodeInputSet extends InputSet {
		/** 
		Set the value of the ListZipCodeList input for this Choreo. 

		@param Integer - (integer) Enter the zipcode for which latitude and longitude coordinates will be retrieved.
		*/
		public void set_ListZipCodeList(Integer value) {
			this.setInput("ListZipCodeList", value);
		}

		/** 
		Set the value of the ListZipCodeList input for this Choreo as a String. 

		@param String - (integer) Enter the zipcode for which latitude and longitude coordinates will be retrieved.
		*/
		public void set_ListZipCodeList(String value) {
			this.setInput("ListZipCodeList", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListCoordinatesForZipcode Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListCoordinatesForZipcodeResultSet extends ResultSet {
		public ListCoordinatesForZipcodeResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (XML) Response from NDFD servers.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
