package com.temboo.Library.LittleSis.Relationship;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetBatchRelationships

Retrieves information about a batch of relationships in LittleSis according to the relationship IDs provided.
*/
public class GetBatchRelationships extends Choreography {

	/**
	Create a new instance of the GetBatchRelationships Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetBatchRelationships(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/LittleSis/Relationship/GetBatchRelationships"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetBatchRelationshipsInputSet
	*/
	public GetBatchRelationshipsInputSet newInputSet() {
		return new GetBatchRelationshipsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetBatchRelationshipsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetBatchRelationshipsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetBatchRelationships
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetBatchRelationshipsInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key obtained from LittleSis.org.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Details input for this Choreo. 

		@param Integer - (optional, integer) Indicate 1 to include details for each relationship record returned. Otherwise, only a basic record will be returned.
		*/
		public void set_Details(Integer value) {
			this.setInput("Details", value);
		}

		/** 
		Set the value of the Details input for this Choreo as a String. 

		@param String - (optional, integer) Indicate 1 to include details for each relationship record returned. Otherwise, only a basic record will be returned.
		*/
		public void set_Details(String value) {
			this.setInput("Details", value);	
		}
		/** 
		Set the value of the RelationshipIDs input for this Choreo. 

		@param String - (required, string) The IDs of the relationship records to be returned as a comma delimited string.
		*/
		public void set_RelationshipIDs(String value) {
			this.setInput("RelationshipIDs", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) Format of the response returned by LittleSis.org. Acceptable inputs: xml or json. Defaults to xml
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetBatchRelationships Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetBatchRelationshipsResultSet extends ResultSet {
		public GetBatchRelationshipsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from LittleSis.org.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
