package com.temboo.Library.Instagram;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetUserInformation

Retrieves basic information about a user.
*/
public class GetUserInformation extends Choreography {

	/**
	Create a new instance of the GetUserInformation Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetUserInformation(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Instagram/GetUserInformation"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetUserInformationInputSet
	*/
	public GetUserInformationInputSet newInputSet() {
		return new GetUserInformationInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetUserInformationResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetUserInformationResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetUserInformation
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetUserInformationInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token retrieved during the OAuth 2.0 process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the UserID input for this Choreo. 

		@param String - (optional, string) The ID of the user that you want to retrieve. Defaults to 'self' indicating that the authenticating user is assumed.
		*/
		public void set_UserID(String value) {
			this.setInput("UserID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetUserInformation Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetUserInformationResultSet extends ResultSet {
		public GetUserInformationResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Instagram.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
