package com.temboo.Library.Instagram;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
DeleteMediaComment

Removes a specified comment from a user's media.
*/
public class DeleteMediaComment extends Choreography {

	/**
	Create a new instance of the DeleteMediaComment Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public DeleteMediaComment(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Instagram/DeleteMediaComment"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return DeleteMediaCommentInputSet
	*/
	public DeleteMediaCommentInputSet newInputSet() {
		return new DeleteMediaCommentInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public DeleteMediaCommentResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new DeleteMediaCommentResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the DeleteMediaComment
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class DeleteMediaCommentInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token retrieved during the OAuth 2.0 process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the CommentID input for this Choreo. 

		@param String - (required, string) The ID of the comment to delete.
		*/
		public void set_CommentID(String value) {
			this.setInput("CommentID", value);
		}


		/** 
		Set the value of the MediaID input for this Choreo. 

		@param String - (required, string) The ID of the media object that you want to delete comments from.
		*/
		public void set_MediaID(String value) {
			this.setInput("MediaID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the DeleteMediaComment Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class DeleteMediaCommentResultSet extends ResultSet {
		public DeleteMediaCommentResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Instagram.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
