package com.temboo.Library.InfluenceExplorer;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
FederalLobbying

Obtain detailed lobbying information.
*/
public class FederalLobbying extends Choreography {

	/**
	Create a new instance of the FederalLobbying Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public FederalLobbying(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/InfluenceExplorer/FederalLobbying"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return FederalLobbyingInputSet
	*/
	public FederalLobbyingInputSet newInputSet() {
		return new FederalLobbyingInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public FederalLobbyingResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new FederalLobbyingResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the FederalLobbying
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class FederalLobbyingInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API key provided by Sunlight Data Services.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Amount input for this Choreo. 

		@param String - (optional, string) Enter the amount of dollars spent on lobbying.  Valid formats include: 500 (exactly $500); >|500 (greater than, or equal to 500); <|500 (less than or equal to 500).
		*/
		public void set_Amount(String value) {
			this.setInput("Amount", value);
		}


		/** 
		Set the value of the ClientParentOrganization input for this Choreo. 

		@param String - (optional, string) Specify a full-text search of a client's parent organizationfor.
		*/
		public void set_ClientParentOrganization(String value) {
			this.setInput("ClientParentOrganization", value);
		}


		/** 
		Set the value of the ClientSearch input for this Choreo. 

		@param String - (optional, string) Enter the name of the client for whom this lobbyist is working. This parameter executes a full-text search.
		*/
		public void set_ClientSearch(String value) {
			this.setInput("ClientSearch", value);
		}


		/** 
		Set the value of the FilingType input for this Choreo. 

		@param String - (optional, string) Specify the type of filing as identified by CRP.  Example: n, for non-self filer parent.  For more info, go here: http://data.influenceexplorer.com/api/lobbying/
		*/
		public void set_FilingType(String value) {
			this.setInput("FilingType", value);
		}


		/** 
		Set the value of the LobbyistSearch input for this Choreo. 

		@param String - (optional, string) Specify a full-text search of a lobbyist's name.
		*/
		public void set_LobbyistSearch(String value) {
			this.setInput("LobbyistSearch", value);
		}


		/** 
		Set the value of the RegistrantSearch input for this Choreo. 

		@param String - (optional, string) Specify a full-text search of an organization or a person, who is fling the lobbyist registration.
		*/
		public void set_RegistrantSearch(String value) {
			this.setInput("RegistrantSearch", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) Indicates the desired format for the response. Accepted values are: json (the default), csv, and xls. Note when specifying xls, restults are returned as Base64 encoded data.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the TransactionID input for this Choreo. 

		@param String - (optional, string) Enter the report ID given by the Senate Office of Public Records.
		*/
		public void set_TransactionID(String value) {
			this.setInput("TransactionID", value);
		}


		/** 
		Set the value of the TransactionType input for this Choreo. 

		@param String - (optional, string) Enter the type of filing as reported by the Senate Office of Public Records. See here for additional info: http://assets.transparencydata.org.s3.amazonaws.com/docs/transaction_types-20100402.csv
		*/
		public void set_TransactionType(String value) {
			this.setInput("TransactionType", value);
		}


		/** 
		Set the value of the YearFiled input for this Choreo. 

		@param String - (optional, string) Specify the year in which a registration was filed. Use the following format: yyyy. Example: 2011. Logical OR is also possible by using the | (pipe) symbol.  Example: 2008|2012.
		*/
		public void set_YearFiled(String value) {
			this.setInput("YearFiled", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the FederalLobbying Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class FederalLobbyingResultSet extends ResultSet {
		public FederalLobbyingResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Influence Explorer. Corresponds to the ResponseFormat input. Defaults to json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
