package com.temboo.Library.GitHub.ReposAPI.Contents;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetReadMe

Retrieves the README file for a repository.
*/
public class GetReadMe extends Choreography {

	/**
	Create a new instance of the GetReadMe Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetReadMe(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/GitHub/ReposAPI/Contents/GetReadMe"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetReadMeInputSet
	*/
	public GetReadMeInputSet newInputSet() {
		return new GetReadMeInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetReadMeResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetReadMeResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetReadMe
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetReadMeInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process. Required when accessing a protected resource.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Ref input for this Choreo. 

		@param String - (optional, string) The name of the commit, branch, or tag. Defaults to "master".
		*/
		public void set_Ref(String value) {
			this.setInput("Ref", value);
		}


		/** 
		Set the value of the Repo input for this Choreo. 

		@param String - (required, string) The name of the repository.
		*/
		public void set_Repo(String value) {
			this.setInput("Repo", value);
		}


		/** 
		Set the value of the User input for this Choreo. 

		@param String - (required, string) The GitHub username.
		*/
		public void set_User(String value) {
			this.setInput("User", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetReadMe Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetReadMeResultSet extends ResultSet {
		public GetReadMeResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Limit" output from this Choreo execution

		@return String - (integer) The available rate limit for your account. This is returned in the GitHub response header.
		*/
		public String get_Limit() {
			return this.getResultString("Limit");
		}
		/** 
		Retrieve the value for the "Remaining" output from this Choreo execution

		@return String - (integer) The remaining number of API requests available to you. This is returned in the GitHub response header.
		*/
		public String get_Remaining() {
			return this.getResultString("Remaining");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from GitHub.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
