package com.temboo.Library.GitHub.GitDataAPI.Tags;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateTag

Creates a tag object.
*/
public class CreateTag extends Choreography {

	/**
	Create a new instance of the CreateTag Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateTag(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/GitHub/GitDataAPI/Tags/CreateTag"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateTagInputSet
	*/
	public CreateTagInputSet newInputSet() {
		return new CreateTagInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateTagResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateTagResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateTag
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateTagInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Message input for this Choreo. 

		@param String - (required, string) The tag message.
		*/
		public void set_Message(String value) {
			this.setInput("Message", value);
		}


		/** 
		Set the value of the Object input for this Choreo. 

		@param String - (required, string) The SHA of the git object that is being tagged.
		*/
		public void set_Object(String value) {
			this.setInput("Object", value);
		}


		/** 
		Set the value of the Repo input for this Choreo. 

		@param String - (required, string) The name of the repo associated with the tag being created.
		*/
		public void set_Repo(String value) {
			this.setInput("Repo", value);
		}


		/** 
		Set the value of the Tag input for this Choreo. 

		@param String - (required, string) A string to use for the tag (i.e. v0.0.1).
		*/
		public void set_Tag(String value) {
			this.setInput("Tag", value);
		}


		/** 
		Set the value of the TaggerDate input for this Choreo. 

		@param String - (required, date) A timestamp of when the object is tagged. Should be formatted like: 2011-06-17T14:53:35-07:00.
		*/
		public void set_TaggerDate(String value) {
			this.setInput("TaggerDate", value);
		}


		/** 
		Set the value of the TaggerEmail input for this Choreo. 

		@param String - (required, string) The email of the author of the tag.
		*/
		public void set_TaggerEmail(String value) {
			this.setInput("TaggerEmail", value);
		}


		/** 
		Set the value of the TaggerName input for this Choreo. 

		@param String - (required, string) The name of the author of the tag.
		*/
		public void set_TaggerName(String value) {
			this.setInput("TaggerName", value);
		}


		/** 
		Set the value of the Type input for this Choreo. 

		@param String - (required, string) The type of object that is being tagged. Valid values are: commit, tree, or blob.
		*/
		public void set_Type(String value) {
			this.setInput("Type", value);
		}


		/** 
		Set the value of the User input for this Choreo. 

		@param String - (required, string) The GitHub username.
		*/
		public void set_User(String value) {
			this.setInput("User", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateTag Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateTagResultSet extends ResultSet {
		public CreateTagResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Limit" output from this Choreo execution

		@return String - (integer) The available rate limit for your account. This is returned in the GitHub response header.
		*/
		public String get_Limit() {
			return this.getResultString("Limit");
		}
		/** 
		Retrieve the value for the "Remaining" output from this Choreo execution

		@return String - (integer) The remaining number of API requests available to you. This is returned in the GitHub response header.
		*/
		public String get_Remaining() {
			return this.getResultString("Remaining");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from GitHub.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
