package com.temboo.Library.GitHub.GistsAPI.Comments;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListComments

Retrieves comments for a specified gist.
*/
public class ListComments extends Choreography {

	/**
	Create a new instance of the ListComments Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListComments(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/GitHub/GistsAPI/Comments/ListComments"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListCommentsInputSet
	*/
	public ListCommentsInputSet newInputSet() {
		return new ListCommentsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListCommentsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListCommentsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListComments
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListCommentsInputSet extends InputSet {
		/** 
		Set the value of the ID input for this Choreo. 

		@param String - (required, string) The id of the gist to fetch comments for.
		*/
		public void set_ID(String value) {
			this.setInput("ID", value);
		}


		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) Indicates the page index that you want to retrieve. Defaults to 1.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) Indicates the page index that you want to retrieve. Defaults to 1.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the PerPage input for this Choreo. 

		@param Integer - (optional, integer) The number of results to return per page.
		*/
		public void set_PerPage(Integer value) {
			this.setInput("PerPage", value);
		}

		/** 
		Set the value of the PerPage input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to return per page.
		*/
		public void set_PerPage(String value) {
			this.setInput("PerPage", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListComments Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListCommentsResultSet extends ResultSet {
		public ListCommentsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "FirstPage" output from this Choreo execution

		@return String - (integer) The index for the first page of results.
		*/
		public String get_FirstPage() {
			return this.getResultString("FirstPage");
		}
		/** 
		Retrieve the value for the "LastPage" output from this Choreo execution

		@return String - (integer) The index for the first page of results.
		*/
		public String get_LastPage() {
			return this.getResultString("LastPage");
		}
		/** 
		Retrieve the value for the "Limit" output from this Choreo execution

		@return String - (integer) The available rate limit for your account. This is returned in the GitHub response header.
		*/
		public String get_Limit() {
			return this.getResultString("Limit");
		}
		/** 
		Retrieve the value for the "NextPage" output from this Choreo execution

		@return String - (integer) The index for the next page of results.
		*/
		public String get_NextPage() {
			return this.getResultString("NextPage");
		}
		/** 
		Retrieve the value for the "PreviousPage" output from this Choreo execution

		@return String - (integer) The index for the previous page of results.
		*/
		public String get_PreviousPage() {
			return this.getResultString("PreviousPage");
		}
		/** 
		Retrieve the value for the "Remaining" output from this Choreo execution

		@return String - (integer) The remaining number of API requests available to you. This is returned in the GitHub response header.
		*/
		public String get_Remaining() {
			return this.getResultString("Remaining");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from GitHub.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
