package com.temboo.Library.Genability.TariffData;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetTerritories

Returns a list of Territory objects based a specified search criteria.
*/
public class GetTerritories extends Choreography {

	/**
	Create a new instance of the GetTerritories Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetTerritories(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Genability/TariffData/GetTerritories"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetTerritoriesInputSet
	*/
	public GetTerritoriesInputSet newInputSet() {
		return new GetTerritoriesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetTerritoriesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetTerritoriesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetTerritories
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetTerritoriesInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (conditional, string) The App ID provided by Genability.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the AppKey input for this Choreo. 

		@param String - (required, string) The App Key provided by Genability.
		*/
		public void set_AppKey(String value) {
			this.setInput("AppKey", value);
		}


		/** 
		Set the value of the ContainsItemType input for this Choreo. 

		@param String - (optional, string) Filters the result set to include a particular type of territory. Valid values are: CITY, ZIPCODE, STATE, COUNTY.
		*/
		public void set_ContainsItemType(String value) {
			this.setInput("ContainsItemType", value);
		}


		/** 
		Set the value of the ContainsItemValue input for this Choreo. 

		@param String - (optional, string) Used in combination with the ContainsItemType value. Filters the Types by this value.
		*/
		public void set_ContainsItemValue(String value) {
			this.setInput("ContainsItemValue", value);
		}


		/** 
		Set the value of the EndsWith input for this Choreo. 

		@param String - (optional, string) When true, the search will only return results that end with the specified search string. Otherwise, any match of the search string will be returned as a result.
		*/
		public void set_EndsWith(String value) {
			this.setInput("EndsWith", value);
		}


		/** 
		Set the value of the IsRegex input for this Choreo. 

		@param Boolean - (optional, boolean) When true, the provided search string will be regarded as a regular expression and the search will return results matching the regular expression.
		*/
		public void set_IsRegex(Boolean value) {
			this.setInput("IsRegex", value);
		}

		/** 
		Set the value of the IsRegex input for this Choreo as a String. 

		@param String - (optional, boolean) When true, the provided search string will be regarded as a regular expression and the search will return results matching the regular expression.
		*/
		public void set_IsRegex(String value) {
			this.setInput("IsRegex", value);	
		}
		/** 
		Set the value of the LSEID input for this Choreo. 

		@param Integer - (optional, integer) Filters the result set to only include territories within this LSE ID.
		*/
		public void set_LSEID(Integer value) {
			this.setInput("LSEID", value);
		}

		/** 
		Set the value of the LSEID input for this Choreo as a String. 

		@param String - (optional, integer) Filters the result set to only include territories within this LSE ID.
		*/
		public void set_LSEID(String value) {
			this.setInput("LSEID", value);	
		}
		/** 
		Set the value of the MasterTariffID input for this Choreo. 

		@param Integer - (optional, integer) For tariffs with prices varying by geographic location, this will return the list of those territories covered by this tariff.
		*/
		public void set_MasterTariffID(Integer value) {
			this.setInput("MasterTariffID", value);
		}

		/** 
		Set the value of the MasterTariffID input for this Choreo as a String. 

		@param String - (optional, integer) For tariffs with prices varying by geographic location, this will return the list of those territories covered by this tariff.
		*/
		public void set_MasterTariffID(String value) {
			this.setInput("MasterTariffID", value);	
		}
		/** 
		Set the value of the PageCount input for this Choreo. 

		@param Integer - (optional, integer) The number of results to return. Defaults to 25.
		*/
		public void set_PageCount(Integer value) {
			this.setInput("PageCount", value);
		}

		/** 
		Set the value of the PageCount input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to return. Defaults to 25.
		*/
		public void set_PageCount(String value) {
			this.setInput("PageCount", value);	
		}
		/** 
		Set the value of the PageStart input for this Choreo. 

		@param Integer - (optional, integer) The page number to begin the result set from. Defaults to 1.
		*/
		public void set_PageStart(Integer value) {
			this.setInput("PageStart", value);
		}

		/** 
		Set the value of the PageStart input for this Choreo as a String. 

		@param String - (optional, integer) The page number to begin the result set from. Defaults to 1.
		*/
		public void set_PageStart(String value) {
			this.setInput("PageStart", value);	
		}
		/** 
		Set the value of the PopulateItems input for this Choreo. 

		@param Boolean - (optional, boolean) If set to "true", returns a list of territory items for each territory in the result set.
		*/
		public void set_PopulateItems(Boolean value) {
			this.setInput("PopulateItems", value);
		}

		/** 
		Set the value of the PopulateItems input for this Choreo as a String. 

		@param String - (optional, boolean) If set to "true", returns a list of territory items for each territory in the result set.
		*/
		public void set_PopulateItems(String value) {
			this.setInput("PopulateItems", value);	
		}
		/** 
		Set the value of the PopulateLSES input for this Choreo. 

		@param String - (optional, string) If set to "true", the response includes a list of TerritoryLses which are all the LSEs providing service in this territory.
		*/
		public void set_PopulateLSES(String value) {
			this.setInput("PopulateLSES", value);
		}


		/** 
		Set the value of the Search input for this Choreo. 

		@param String - (optional, string) The string of text to search on. This can also be a regular expression, in which case you should set the 'isRegex' flag to true.
		*/
		public void set_Search(String value) {
			this.setInput("Search", value);
		}


		/** 
		Set the value of the SearchOn input for this Choreo. 

		@param String - (optional, string) Comma separated list of fields to query on. When searchOn is specified, the text provided in the search string field will be searched within these fields.
		*/
		public void set_SearchOn(String value) {
			this.setInput("SearchOn", value);
		}


		/** 
		Set the value of the SortOn input for this Choreo. 

		@param String - (optional, string) Comma separated list of fields to sort on.
		*/
		public void set_SortOn(String value) {
			this.setInput("SortOn", value);
		}


		/** 
		Set the value of the SortOrder input for this Choreo. 

		@param String - (optional, string) Comma separated list of ordering. Possible values are 'ASC' and 'DESC'. Default is 'ASC'. This list corresponds to the field list used in the SortOn input.
		*/
		public void set_SortOrder(String value) {
			this.setInput("SortOrder", value);
		}


		/** 
		Set the value of the StartsWith input for this Choreo. 

		@param Boolean - (optional, boolean) When true, the search will only return results that begin with the specified search string. Otherwise, any match of the search string will be returned as a result.
		*/
		public void set_StartsWith(Boolean value) {
			this.setInput("StartsWith", value);
		}

		/** 
		Set the value of the StartsWith input for this Choreo as a String. 

		@param String - (optional, boolean) When true, the search will only return results that begin with the specified search string. Otherwise, any match of the search string will be returned as a result.
		*/
		public void set_StartsWith(String value) {
			this.setInput("StartsWith", value);	
		}
		/** 
		Set the value of the UsageTypes input for this Choreo. 

		@param String - (optional, string) Filters the result set to only include territories of the specified usageType. valid values are: SERVICE, TARIFF.
		*/
		public void set_UsageTypes(String value) {
			this.setInput("UsageTypes", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetTerritories Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetTerritoriesResultSet extends ResultSet {
		public GetTerritoriesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Genability.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
