package com.temboo.Library.Genability.PricingAndCalc;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetPrice

Retrieves the consumption price of a specified Tariff over a given date range.
*/
public class GetPrice extends Choreography {

	/**
	Create a new instance of the GetPrice Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetPrice(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Genability/PricingAndCalc/GetPrice"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetPriceInputSet
	*/
	public GetPriceInputSet newInputSet() {
		return new GetPriceInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetPriceResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetPriceResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetPrice
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetPriceInputSet extends InputSet {
		/** 
		Set the value of the AccountID input for this Choreo. 

		@param String - (optional, string) A Genability ID for an account. More info on Accounts is available here: http://developer.genability.com/documentation/api-reference/account-api/account
		*/
		public void set_AccountID(String value) {
			this.setInput("AccountID", value);
		}


		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (required, string) The App ID provided by Genability.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the AppKey input for this Choreo. 

		@param String - (required, string) The App Key provided by Genability.
		*/
		public void set_AppKey(String value) {
			this.setInput("AppKey", value);
		}


		/** 
		Set the value of the ConsumptionAmount input for this Choreo. 

		@param BigDecimal - (optional, decimal) Specify a monthly consumption in kWh. By default the highest banded level of consumption is used.
		*/
		public void set_ConsumptionAmount(BigDecimal value) {
			this.setInput("ConsumptionAmount", value);
		}

		/** 
		Set the value of the ConsumptionAmount input for this Choreo as a String. 

		@param String - (optional, decimal) Specify a monthly consumption in kWh. By default the highest banded level of consumption is used.
		*/
		public void set_ConsumptionAmount(String value) {
			this.setInput("ConsumptionAmount", value);	
		}
		/** 
		Set the value of the DemandAmount input for this Choreo. 

		@param BigDecimal - (optional, decimal) Specify a monthly demand in kWh. By default the highest banded level of demand is used.
		*/
		public void set_DemandAmount(BigDecimal value) {
			this.setInput("DemandAmount", value);
		}

		/** 
		Set the value of the DemandAmount input for this Choreo as a String. 

		@param String - (optional, decimal) Specify a monthly demand in kWh. By default the highest banded level of demand is used.
		*/
		public void set_DemandAmount(String value) {
			this.setInput("DemandAmount", value);	
		}
		/** 
		Set the value of the FromDateTime input for this Choreo. 

		@param String - (required, string) The date and time of the requested start of the price query. Must be in ISO 8601 format.  Example: 2012-06-12T00:00:00.0-0700
		*/
		public void set_FromDateTime(String value) {
			this.setInput("FromDateTime", value);
		}


		/** 
		Set the value of the MasterTariffID input for this Choreo. 

		@param String - (optional, string) A Genability tariff ID. Not required, if AccountID is specified.
		*/
		public void set_MasterTariffID(String value) {
			this.setInput("MasterTariffID", value);
		}


		/** 
		Set the value of the PageCount input for this Choreo. 

		@param Integer - (optional, integer) The number of results to be returned. Defailt is set to: 25.
		*/
		public void set_PageCount(Integer value) {
			this.setInput("PageCount", value);
		}

		/** 
		Set the value of the PageCount input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to be returned. Defailt is set to: 25.
		*/
		public void set_PageCount(String value) {
			this.setInput("PageCount", value);	
		}
		/** 
		Set the value of the PageStart input for this Choreo. 

		@param Integer - (optional, integer) The page number to start to display results from. If unspecified, the first page of results will be returned.
		*/
		public void set_PageStart(Integer value) {
			this.setInput("PageStart", value);
		}

		/** 
		Set the value of the PageStart input for this Choreo as a String. 

		@param String - (optional, integer) The page number to start to display results from. If unspecified, the first page of results will be returned.
		*/
		public void set_PageStart(String value) {
			this.setInput("PageStart", value);	
		}
		/** 
		Set the value of the ProfileID input for this Choreo. 

		@param String - (optional, string) The Genability ID of a profile. This ID can be passed instead of consumptionAmount or demandAmount.
		*/
		public void set_ProfileID(String value) {
			this.setInput("ProfileID", value);
		}


		/** 
		Set the value of the ProviderAccountID input for this Choreo. 

		@param String - (optional, string) A unique ID for an Account. Same as AccountId, however your unique ID can be used instead of the Genability Account ID.
		*/
		public void set_ProviderAccountID(String value) {
			this.setInput("ProviderAccountID", value);
		}


		/** 
		Set the value of the TerritoryID input for this Choreo. 

		@param String - (optional, string) Return rate changes for the specified Territory.
		*/
		public void set_TerritoryID(String value) {
			this.setInput("TerritoryID", value);
		}


		/** 
		Set the value of the ToDateTime input for this Choreo. 

		@param String - (optional, string) The date and time of the requested start of the price query. Must be in ISO 8601 format.  Example: 2012-06-12T00:00:00.0-0700
		*/
		public void set_ToDateTime(String value) {
			this.setInput("ToDateTime", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetPrice Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetPriceResultSet extends ResultSet {
		public GetPriceResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Genability.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
