package com.temboo.Library.Foursquare.Venues;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Explore

Returns a list of recommended venues near the current location.
*/
public class Explore extends Choreography {

	/**
	Create a new instance of the Explore Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Explore(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Foursquare/Venues/Explore"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ExploreInputSet
	*/
	public ExploreInputSet newInputSet() {
		return new ExploreInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ExploreResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ExploreResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Explore
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ExploreInputSet extends InputSet {
		/** 
		Set the value of the AccuracyOfCoordinates input for this Choreo. 

		@param Integer - (optional, integer) Accuracy of latitude and longitude, in meters.
		*/
		public void set_AccuracyOfCoordinates(Integer value) {
			this.setInput("AccuracyOfCoordinates", value);
		}

		/** 
		Set the value of the AccuracyOfCoordinates input for this Choreo as a String. 

		@param String - (optional, integer) Accuracy of latitude and longitude, in meters.
		*/
		public void set_AccuracyOfCoordinates(String value) {
			this.setInput("AccuracyOfCoordinates", value);	
		}
		/** 
		Set the value of the Altitude input for this Choreo. 

		@param Integer - (optional, integer) Altitude of the user's location, in meters.
		*/
		public void set_Altitude(Integer value) {
			this.setInput("Altitude", value);
		}

		/** 
		Set the value of the Altitude input for this Choreo as a String. 

		@param String - (optional, integer) Altitude of the user's location, in meters.
		*/
		public void set_Altitude(String value) {
			this.setInput("Altitude", value);	
		}
		/** 
		Set the value of the AltitudeAccuracy input for this Choreo. 

		@param Integer - (optional, integer) Accuracy of the user's altitude, in meters.
		*/
		public void set_AltitudeAccuracy(Integer value) {
			this.setInput("AltitudeAccuracy", value);
		}

		/** 
		Set the value of the AltitudeAccuracy input for this Choreo as a String. 

		@param String - (optional, integer) Accuracy of the user's altitude, in meters.
		*/
		public void set_AltitudeAccuracy(String value) {
			this.setInput("AltitudeAccuracy", value);	
		}
		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) Your Foursquare client ID, obtained after registering at Foursquare. Required unless using the OauthToken input.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) Your Foursquare client secret, obtained after registering at Foursquare. Required unless using the OauthToken input.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the Day input for this Choreo. 

		@param String - (optional, string) When set to "any", results for any day of the week are returned. Results that are targeted to the current day of the week are returned by default.
		*/
		public void set_Day(String value) {
			this.setInput("Day", value);
		}


		/** 
		Set the value of the FriendsVisits input for this Choreo. 

		@param String - (optional, string) Limits results to places the acting user's friends have or haven't been. Valid values are: "visited" or "notvisited". 
		*/
		public void set_FriendsVisits(String value) {
			this.setInput("FriendsVisits", value);
		}


		/** 
		Set the value of the Intent input for this Choreo. 

		@param String - (optional, string) Used in combination with the LastVenue input.  Return venues users often visit after a given venue when setting to "nextVenues" and providing a venue ID for the LastVenue input.
		*/
		public void set_Intent(String value) {
			this.setInput("Intent", value);
		}


		/** 
		Set the value of the LastVenue input for this Choreo. 

		@param String - (optional, string) A venue ID to use when Intent = "nextVenues", which returns venues users often visit after a given venue. See Choreo notes for more details about the use of this input.
		*/
		public void set_LastVenue(String value) {
			this.setInput("LastVenue", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (conditional, decimal) The latitude point of the user's location. Required unless the Near parameter is provided.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (conditional, decimal) The latitude point of the user's location. Required unless the Near parameter is provided.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) Number of results to return, up to 50.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) Number of results to return, up to 50.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (conditional, decimal) The longitude point of the user's location. Required unless the Near parameter is provided.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (conditional, decimal) The longitude point of the user's location. Required unless the Near parameter is provided.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the Near input for this Choreo. 

		@param String - (conditional, string) A string naming a place in the world. If the near string is not geocodable, returns a failed_geocode error. Required unless provided Latitude and Longitude.
		*/
		public void set_Near(String value) {
			this.setInput("Near", value);
		}


		/** 
		Set the value of the Novelty input for this Choreo. 

		@param String - (optional, string) Pass "new" or "old" to limit results to places the acting user hasn't been or has been, respectively. Omitting this parameter returns a mixture of both new and old.
		*/
		public void set_Novelty(String value) {
			this.setInput("Novelty", value);
		}


		/** 
		Set the value of the OauthToken input for this Choreo. 

		@param String - (conditional, string) The Foursquare API OAuth token string. Required unless specifying the ClientID and ClientSecret.
		*/
		public void set_OauthToken(String value) {
			this.setInput("OauthToken", value);
		}


		/** 
		Set the value of the Offset input for this Choreo. 

		@param Integer - (optional, integer) Used with the Limit input to page through results.
		*/
		public void set_Offset(Integer value) {
			this.setInput("Offset", value);
		}

		/** 
		Set the value of the Offset input for this Choreo as a String. 

		@param String - (optional, integer) Used with the Limit input to page through results.
		*/
		public void set_Offset(String value) {
			this.setInput("Offset", value);	
		}
		/** 
		Set the value of the OpenNow input for this Choreo. 

		@param Boolean - (optional, boolean) Set to 1 to only include venues that are open now. Defaults to 0.
		*/
		public void set_OpenNow(Boolean value) {
			this.setInput("OpenNow", value);
		}

		/** 
		Set the value of the OpenNow input for this Choreo as a String. 

		@param String - (optional, boolean) Set to 1 to only include venues that are open now. Defaults to 0.
		*/
		public void set_OpenNow(String value) {
			this.setInput("OpenNow", value);	
		}
		/** 
		Set the value of the Price input for this Choreo. 

		@param String - (optional, string) A comma separated list of price points. Currently the valid range of price points are: [1,2,3,4]. See Choreo notes for more details about the use of this parameter.
		*/
		public void set_Price(String value) {
			this.setInput("Price", value);
		}


		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (optional, string) A search term to be applied against tips, category, etc. at a venue.
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


		/** 
		Set the value of the Radius input for this Choreo. 

		@param Integer - (optional, integer) Radius to search within, in meters. If radius is not specified, a suggested radius will be used depending on the density of venues in the area.
		*/
		public void set_Radius(Integer value) {
			this.setInput("Radius", value);
		}

		/** 
		Set the value of the Radius input for this Choreo as a String. 

		@param String - (optional, integer) Radius to search within, in meters. If radius is not specified, a suggested radius will be used depending on the density of venues in the area.
		*/
		public void set_Radius(String value) {
			this.setInput("Radius", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Saved input for this Choreo. 

		@param Boolean - (optional, boolean) Set to 1 to only include venues that the user has saved on their To-Do list or to another list. Defaults to 0.
		*/
		public void set_Saved(Boolean value) {
			this.setInput("Saved", value);
		}

		/** 
		Set the value of the Saved input for this Choreo as a String. 

		@param String - (optional, boolean) Set to 1 to only include venues that the user has saved on their To-Do list or to another list. Defaults to 0.
		*/
		public void set_Saved(String value) {
			this.setInput("Saved", value);	
		}
		/** 
		Set the value of the Section input for this Choreo. 

		@param String - (optional, string) One of food, drinks, coffee, shops, arts, outdoors, sights, trending, specials, nextVenues , or topPicks. Choosing one of these limits results to venues with categories matching these terms.
		*/
		public void set_Section(String value) {
			this.setInput("Section", value);
		}


		/** 
		Set the value of the SortByDistance input for this Choreo. 

		@param Boolean - (optional, boolean) Set to 1 to sort the results by distance instead of relevance. Default to 0.
		*/
		public void set_SortByDistance(Boolean value) {
			this.setInput("SortByDistance", value);
		}

		/** 
		Set the value of the SortByDistance input for this Choreo as a String. 

		@param String - (optional, boolean) Set to 1 to sort the results by distance instead of relevance. Default to 0.
		*/
		public void set_SortByDistance(String value) {
			this.setInput("SortByDistance", value);	
		}
		/** 
		Set the value of the Specials input for this Choreo. 

		@param Boolean - (optional, boolean) Set to 1 to only include venues that have a special. Defaults to 0.
		*/
		public void set_Specials(Boolean value) {
			this.setInput("Specials", value);
		}

		/** 
		Set the value of the Specials input for this Choreo as a String. 

		@param String - (optional, boolean) Set to 1 to only include venues that have a special. Defaults to 0.
		*/
		public void set_Specials(String value) {
			this.setInput("Specials", value);	
		}
		/** 
		Set the value of the Time input for this Choreo. 

		@param String - (optional, string) When set to "any", results for any time of day are returned. Results that are targeted to the current time of day are returned by default.
		*/
		public void set_Time(String value) {
			this.setInput("Time", value);
		}


		/** 
		Set the value of the VenuePhotos input for this Choreo. 

		@param Boolean - (optional, boolean) Set to 1 to include a photo for each venue in response, if one is available. Default is 0 (no photos).
		*/
		public void set_VenuePhotos(Boolean value) {
			this.setInput("VenuePhotos", value);
		}

		/** 
		Set the value of the VenuePhotos input for this Choreo as a String. 

		@param String - (optional, boolean) Set to 1 to include a photo for each venue in response, if one is available. Default is 0 (no photos).
		*/
		public void set_VenuePhotos(String value) {
			this.setInput("VenuePhotos", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Explore Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ExploreResultSet extends ResultSet {
		public ExploreResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Foursquare. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
