package com.temboo.Library.Fitbit.Profile;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateUserInfo

Updates a user's profile data.
*/
public class UpdateUserInfo extends Choreography {

	/**
	Create a new instance of the UpdateUserInfo Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateUserInfo(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Fitbit/Profile/UpdateUserInfo"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateUserInfoInputSet
	*/
	public UpdateUserInfoInputSet newInputSet() {
		return new UpdateUserInfoInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateUserInfoResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateUserInfoResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateUserInfo
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateUserInfoInputSet extends InputSet {
		/** 
		Set the value of the AboutMe input for this Choreo. 

		@param String - (optional, string) The user's About Me string.
		*/
		public void set_AboutMe(String value) {
			this.setInput("AboutMe", value);
		}


		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the Birthday input for this Choreo. 

		@param String - (optional, date) Date of Birth; in the format yyyy-MM-dd.
		*/
		public void set_Birthday(String value) {
			this.setInput("Birthday", value);
		}


		/** 
		Set the value of the City input for this Choreo. 

		@param String - (optional, string) The user's city information.
		*/
		public void set_City(String value) {
			this.setInput("City", value);
		}


		/** 
		Set the value of the ConsumerKey input for this Choreo. 

		@param String - (required, string) The Consumer Key provided by Fitbit.
		*/
		public void set_ConsumerKey(String value) {
			this.setInput("ConsumerKey", value);
		}


		/** 
		Set the value of the ConsumerSecret input for this Choreo. 

		@param String - (required, string) The Consumer Secret provided by Fitbit.
		*/
		public void set_ConsumerSecret(String value) {
			this.setInput("ConsumerSecret", value);
		}


		/** 
		Set the value of the Country input for this Choreo. 

		@param String - (optional, string) The two-character code for the user's country.
		*/
		public void set_Country(String value) {
			this.setInput("Country", value);
		}


		/** 
		Set the value of the FoodLocale input for this Choreo. 

		@param String - (optional, string) Food Database Locale; in the format "xx_XX".
		*/
		public void set_FoodLocale(String value) {
			this.setInput("FoodLocale", value);
		}


		/** 
		Set the value of the FullName input for this Choreo. 

		@param String - (optional, string) The user's full name.
		*/
		public void set_FullName(String value) {
			this.setInput("FullName", value);
		}


		/** 
		Set the value of the Gender input for this Choreo. 

		@param String - (optional, string) The user's gender (MALE/FEMALE/NA).
		*/
		public void set_Gender(String value) {
			this.setInput("Gender", value);
		}


		/** 
		Set the value of the GlucoseUnit input for this Choreo. 

		@param BigDecimal - (optional, decimal) The blood glucose unit of measurement being used. Valid values are: en_US, any,  METRIC.
		*/
		public void set_GlucoseUnit(BigDecimal value) {
			this.setInput("GlucoseUnit", value);
		}

		/** 
		Set the value of the GlucoseUnit input for this Choreo as a String. 

		@param String - (optional, decimal) The blood glucose unit of measurement being used. Valid values are: en_US, any,  METRIC.
		*/
		public void set_GlucoseUnit(String value) {
			this.setInput("GlucoseUnit", value);	
		}
		/** 
		Set the value of the Height input for this Choreo. 

		@param BigDecimal - (optional, decimal) The user's height; in the format X.XX (inches).
		*/
		public void set_Height(BigDecimal value) {
			this.setInput("Height", value);
		}

		/** 
		Set the value of the Height input for this Choreo as a String. 

		@param String - (optional, decimal) The user's height; in the format X.XX (inches).
		*/
		public void set_Height(String value) {
			this.setInput("Height", value);	
		}
		/** 
		Set the value of the HeightUnit input for this Choreo. 

		@param BigDecimal - (optional, decimal) The height unit being used. Valid values are: en_US, any,  METRIC.
		*/
		public void set_HeightUnit(BigDecimal value) {
			this.setInput("HeightUnit", value);
		}

		/** 
		Set the value of the HeightUnit input for this Choreo as a String. 

		@param String - (optional, decimal) The height unit being used. Valid values are: en_US, any,  METRIC.
		*/
		public void set_HeightUnit(String value) {
			this.setInput("HeightUnit", value);	
		}
		/** 
		Set the value of the Locale input for this Choreo. 

		@param String - (optional, string) Locale of website (country/language); one of the locales, currently – (en_US, fr_FR, de_DE, es_ES, en_GB, en_AU, en_NZ, ja_JP).
		*/
		public void set_Locale(String value) {
			this.setInput("Locale", value);
		}


		/** 
		Set the value of the Nickname input for this Choreo. 

		@param String - (optional, string) The user's nickname.
		*/
		public void set_Nickname(String value) {
			this.setInput("Nickname", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that you want the response to be in: xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the State input for this Choreo. 

		@param String - (optional, string) The two-character state abbreviation for the user.
		*/
		public void set_State(String value) {
			this.setInput("State", value);
		}


		/** 
		Set the value of the StrideLengthRunning input for this Choreo. 

		@param BigDecimal - (optional, decimal) Running stride length; in the format X.XX.
		*/
		public void set_StrideLengthRunning(BigDecimal value) {
			this.setInput("StrideLengthRunning", value);
		}

		/** 
		Set the value of the StrideLengthRunning input for this Choreo as a String. 

		@param String - (optional, decimal) Running stride length; in the format X.XX.
		*/
		public void set_StrideLengthRunning(String value) {
			this.setInput("StrideLengthRunning", value);	
		}
		/** 
		Set the value of the StrideLengthWalking input for this Choreo. 

		@param BigDecimal - (optional, decimal) Walking stride length; in the format X.XX.
		*/
		public void set_StrideLengthWalking(BigDecimal value) {
			this.setInput("StrideLengthWalking", value);
		}

		/** 
		Set the value of the StrideLengthWalking input for this Choreo as a String. 

		@param String - (optional, decimal) Walking stride length; in the format X.XX.
		*/
		public void set_StrideLengthWalking(String value) {
			this.setInput("StrideLengthWalking", value);	
		}
		/** 
		Set the value of the Timezone input for this Choreo. 

		@param String - (optional, string) The user's timezone; in the format "America/Los_Angeles"
		*/
		public void set_Timezone(String value) {
			this.setInput("Timezone", value);
		}


		/** 
		Set the value of the UserID input for this Choreo. 

		@param String - (optional, string) The user's encoded id. Defaults to "-" (dash) which will return data for the user associated with the token credentials provided.
		*/
		public void set_UserID(String value) {
			this.setInput("UserID", value);
		}


		/** 
		Set the value of the WaterUnit input for this Choreo. 

		@param BigDecimal - (optional, decimal) The water unit being used. Valid values are: en_US, any,  METRIC.
		*/
		public void set_WaterUnit(BigDecimal value) {
			this.setInput("WaterUnit", value);
		}

		/** 
		Set the value of the WaterUnit input for this Choreo as a String. 

		@param String - (optional, decimal) The water unit being used. Valid values are: en_US, any,  METRIC.
		*/
		public void set_WaterUnit(String value) {
			this.setInput("WaterUnit", value);	
		}
		/** 
		Set the value of the WeightUnit input for this Choreo. 

		@param String - (optional, string) The weight unit being used. Valid values are: en_US, any,  METRIC.
		*/
		public void set_WeightUnit(String value) {
			this.setInput("WeightUnit", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateUserInfo Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateUserInfoResultSet extends ResultSet {
		public UpdateUserInfoResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Fitbit.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
