package com.temboo.Library.Fitbit.Activities;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetActivityDailyGoals

Get a user's current daily activity goals.
*/
public class GetActivityDailyGoals extends Choreography {

	/**
	Create a new instance of the GetActivityDailyGoals Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetActivityDailyGoals(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Fitbit/Activities/GetActivityDailyGoals"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetActivityDailyGoalsInputSet
	*/
	public GetActivityDailyGoalsInputSet newInputSet() {
		return new GetActivityDailyGoalsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetActivityDailyGoalsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetActivityDailyGoalsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetActivityDailyGoals
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetActivityDailyGoalsInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the ConsumerKey input for this Choreo. 

		@param String - (required, string) The Consumer Key provided by Fitbit.
		*/
		public void set_ConsumerKey(String value) {
			this.setInput("ConsumerKey", value);
		}


		/** 
		Set the value of the ConsumerSecret input for this Choreo. 

		@param String - (required, string) The Consumer Secret provided by Fitbit.
		*/
		public void set_ConsumerSecret(String value) {
			this.setInput("ConsumerSecret", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that you want the response to be in: xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the UserID input for this Choreo. 

		@param String - (optional, string) The user's encoded id. Defaults to "-" (dash) which will return data for the user associated with the token credentials provided.
		*/
		public void set_UserID(String value) {
			this.setInput("UserID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetActivityDailyGoals Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetActivityDailyGoalsResultSet extends ResultSet {
		public GetActivityDailyGoalsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "CaloriesOut" output from this Choreo execution

		@return String - (integer) The number representing the daily calorie burn goal.
		*/
		public String get_CaloriesOut() {
			return this.getResultString("CaloriesOut");
		}
		/** 
		Retrieve the value for the "Distance" output from this Choreo execution

		@return String - (decimal) The distance specified as the daily goal.
		*/
		public String get_Distance() {
			return this.getResultString("Distance");
		}
		/** 
		Retrieve the value for the "Steps" output from this Choreo execution

		@return String - (integer) The number of steps specified for a daily goal.
		*/
		public String get_Steps() {
			return this.getResultString("Steps");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Fitbit.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
