package com.temboo.Library.Facebook.BatchRequests;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Batch

Allows you to perform multiple graph operations in one request.
*/
public class Batch extends Choreography {

	/**
	Create a new instance of the Batch Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Batch(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Facebook/BatchRequests/Batch"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return BatchInputSet
	*/
	public BatchInputSet newInputSet() {
		return new BatchInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public BatchResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new BatchResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Batch
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class BatchInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token retrieved from the final step of the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Batch input for this Choreo. 

		@param String - (required, json) A JSON object which describes each individual operation you'd like to perform. See documentation for syntax examples.
		*/
		public void set_Batch(String value) {
			this.setInput("Batch", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Batch Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class BatchResultSet extends ResultSet {
		public BatchResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (string) Contains the Base64 encoded value of the image retrieved from Facebook.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
