package com.temboo.Library.EnviroFacts.DesignForEnvironment;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SearchBySector

Looks up products by sector in the EPA Design for the Environment database
*/
public class SearchBySector extends Choreography {

	/**
	Create a new instance of the SearchBySector Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SearchBySector(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/EnviroFacts/DesignForEnvironment/SearchBySector"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchBySectorInputSet
	*/
	public SearchBySectorInputSet newInputSet() {
		return new SearchBySectorInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchBySectorResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchBySectorResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SearchBySector
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchBySectorInputSet extends InputSet {
		/** 
		Set the value of the Category input for this Choreo. 

		@param String - (conditional, string) Specify either Industrial or Consumer to retrieve a list of products that fall into either category. If a specific SectorKeyword or SectorID is given, this input is ignored.
		*/
		public void set_Category(String value) {
			this.setInput("Category", value);
		}


		/** 
		Set the value of the Operator input for this Choreo. 

		@param String - (optional, string) Default output is "CONTAINING" and does not require an operator, but users can enter "<", " >", "!=", "BEGINNING", "=" for more customized searches.
		*/
		public void set_Operator(String value) {
			this.setInput("Operator", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (conditional, string) Response can be returned in JSON or XML. Defaults to XML.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the RowEnd input for this Choreo. 

		@param Integer - (optional, integer) Number 1 or greater indicates the ending row number of the results displayed. Default is 4999 when RowStart is 0. Up to 5000 entries are returned in the output.
		*/
		public void set_RowEnd(Integer value) {
			this.setInput("RowEnd", value);
		}

		/** 
		Set the value of the RowEnd input for this Choreo as a String. 

		@param String - (optional, integer) Number 1 or greater indicates the ending row number of the results displayed. Default is 4999 when RowStart is 0. Up to 5000 entries are returned in the output.
		*/
		public void set_RowEnd(String value) {
			this.setInput("RowEnd", value);	
		}
		/** 
		Set the value of the RowStart input for this Choreo. 

		@param Integer - (optional, integer) Indicates the starting row number of the results displayed. Default is 0.
		*/
		public void set_RowStart(Integer value) {
			this.setInput("RowStart", value);
		}

		/** 
		Set the value of the RowStart input for this Choreo as a String. 

		@param String - (optional, integer) Indicates the starting row number of the results displayed. Default is 0.
		*/
		public void set_RowStart(String value) {
			this.setInput("RowStart", value);	
		}
		/** 
		Set the value of the SectorID input for this Choreo. 

		@param Integer - (conditional, integer) A number representing the unique identifier for the product's sector in the EnviroFacts database.
		*/
		public void set_SectorID(Integer value) {
			this.setInput("SectorID", value);
		}

		/** 
		Set the value of the SectorID input for this Choreo as a String. 

		@param String - (conditional, integer) A number representing the unique identifier for the product's sector in the EnviroFacts database.
		*/
		public void set_SectorID(String value) {
			this.setInput("SectorID", value);	
		}
		/** 
		Set the value of the SectorKeyword input for this Choreo. 

		@param String - (conditional, string) A keyword in the name of the sector to search for. If a specific SectorID is given, this input is ignored.
		*/
		public void set_SectorKeyword(String value) {
			this.setInput("SectorKeyword", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SearchBySector Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchBySectorResultSet extends ResultSet {
		public SearchBySectorResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Count" output from this Choreo execution

		@return String - The total number of records returned for any given search.
		*/
		public String get_Count() {
			return this.getResultString("Count");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from EnviroFacts.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
