package com.temboo.Library.Dropbox.FilesAndMetadata;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
LatestCursor

Allows you to quickly get a cursor for the server's state, for use with the Delta Choreo.
*/
public class LatestCursor extends Choreography {

	/**
	Create a new instance of the LatestCursor Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public LatestCursor(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Dropbox/FilesAndMetadata/LatestCursor"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return LatestCursorInputSet
	*/
	public LatestCursorInputSet newInputSet() {
		return new LatestCursorInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public LatestCursorResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new LatestCursorResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the LatestCursor
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class LatestCursorInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the AppKey input for this Choreo. 

		@param String - (required, string) The App Key provided by Dropbox (AKA the OAuth Consumer Key).
		*/
		public void set_AppKey(String value) {
			this.setInput("AppKey", value);
		}


		/** 
		Set the value of the AppSecret input for this Choreo. 

		@param String - (required, string) The App Secret provided by Dropbox (AKA the OAuth Consumer Secret).
		*/
		public void set_AppSecret(String value) {
			this.setInput("AppSecret", value);
		}


		/** 
		Set the value of the IncludeMediaInfo input for this Choreo. 

		@param Boolean - (optional, boolean) If true, the returned cursor will be encoded with include_media_info set to true for use with the Delta Choreo.
		*/
		public void set_IncludeMediaInfo(Boolean value) {
			this.setInput("IncludeMediaInfo", value);
		}

		/** 
		Set the value of the IncludeMediaInfo input for this Choreo as a String. 

		@param String - (optional, boolean) If true, the returned cursor will be encoded with include_media_info set to true for use with the Delta Choreo.
		*/
		public void set_IncludeMediaInfo(String value) {
			this.setInput("IncludeMediaInfo", value);	
		}
		/** 
		Set the value of the PathPrefix input for this Choreo. 

		@param String - (optional, string) If present, the returned cursor will be encoded with a path_prefix for the specified path for use with the Delta Choreo.
		*/
		public void set_PathPrefix(String value) {
			this.setInput("PathPrefix", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the LatestCursor Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class LatestCursorResultSet extends ResultSet {
		public LatestCursorResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Dropbox. Corresponds to the ResponseFormat input. Defaults to json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
