package com.temboo.Library.Dropbox.FileOperations;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CopyFileOrFolder

Copies a file or folder to a new location in the Dropbox tree.
*/
public class CopyFileOrFolder extends Choreography {

	/**
	Create a new instance of the CopyFileOrFolder Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CopyFileOrFolder(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Dropbox/FileOperations/CopyFileOrFolder"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CopyFileOrFolderInputSet
	*/
	public CopyFileOrFolderInputSet newInputSet() {
		return new CopyFileOrFolderInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CopyFileOrFolderResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CopyFileOrFolderResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CopyFileOrFolder
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CopyFileOrFolderInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the AppKey input for this Choreo. 

		@param String - (required, string) The App Key provided by Dropbox (AKA the OAuth Consumer Key).
		*/
		public void set_AppKey(String value) {
			this.setInput("AppKey", value);
		}


		/** 
		Set the value of the AppSecret input for this Choreo. 

		@param String - (required, string) The App Secret provided by Dropbox (AKA the OAuth Consumer Secret).
		*/
		public void set_AppSecret(String value) {
			this.setInput("AppSecret", value);
		}


		/** 
		Set the value of the FromCopyRef input for this Choreo. 

		@param String - (conditional, string) Specifies a CopyRef previously generated by running the CreateCopyRef choreo. If you specify this value, you must leave FromPath empty.
		*/
		public void set_FromCopyRef(String value) {
			this.setInput("FromCopyRef", value);
		}


		/** 
		Set the value of the FromPath input for this Choreo. 

		@param String - (conditional, string) Specifies the file or folder to be copied. If you specify this value, you must leave the FromCopyRef blank.
		*/
		public void set_FromPath(String value) {
			this.setInput("FromPath", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Root input for this Choreo. 

		@param String - (optional, string) Defaults to "auto" which automatically determines the root folder using your app's permission level. Other options are "sandbox" (App Folder) and "dropbox" (Full Dropbox).
		*/
		public void set_Root(String value) {
			this.setInput("Root", value);
		}


		/** 
		Set the value of the ToPath input for this Choreo. 

		@param String - (required, string) Specifies the destination path, including the new name for the file or folder.
		*/
		public void set_ToPath(String value) {
			this.setInput("ToPath", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CopyFileOrFolder Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CopyFileOrFolderResultSet extends ResultSet {
		public CopyFileOrFolderResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Dropbox. Corresponds to the ResponseFormat input. Defaults to json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
