package com.temboo.Library.DonorsChoose;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
DonateToProject

Makes a donation to a specified DonorsChoose.org project.
*/
public class DonateToProject extends Choreography {

	/**
	Create a new instance of the DonateToProject Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public DonateToProject(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/DonorsChoose/DonateToProject"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return DonateToProjectInputSet
	*/
	public DonateToProjectInputSet newInputSet() {
		return new DonateToProjectInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public DonateToProjectResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new DonateToProjectResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the DonateToProject
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class DonateToProjectInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The APIKey provided by DonorsChoose.org.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APIPassword input for this Choreo. 

		@param String - (required, string) Your DonorsChoose.org API password. This is only required when performing transactions.
		*/
		public void set_APIPassword(String value) {
			this.setInput("APIPassword", value);
		}


		/** 
		Set the value of the Address1 input for this Choreo. 

		@param String - (optional, string) Line one of the donor's address.
		*/
		public void set_Address1(String value) {
			this.setInput("Address1", value);
		}


		/** 
		Set the value of the Address2 input for this Choreo. 

		@param String - (optional, string) Line two of the donor's address.
		*/
		public void set_Address2(String value) {
			this.setInput("Address2", value);
		}


		/** 
		Set the value of the Amount input for this Choreo. 

		@param Integer - (required, integer) The donation amount. Must be a whole number.
		*/
		public void set_Amount(Integer value) {
			this.setInput("Amount", value);
		}

		/** 
		Set the value of the Amount input for this Choreo as a String. 

		@param String - (required, integer) The donation amount. Must be a whole number.
		*/
		public void set_Amount(String value) {
			this.setInput("Amount", value);	
		}
		/** 
		Set the value of the Callback input for this Choreo. 

		@param String - (optional, string) To wrap the response in a callback function, include the name in this input.
		*/
		public void set_Callback(String value) {
			this.setInput("Callback", value);
		}


		/** 
		Set the value of the City input for this Choreo. 

		@param String - (optional, string) The donor's city.
		*/
		public void set_City(String value) {
			this.setInput("City", value);
		}


		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (required, string) The email address of the person who is making the donation.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the FirstName input for this Choreo. 

		@param String - (optional, string) The first name of the donor.
		*/
		public void set_FirstName(String value) {
			this.setInput("FirstName", value);
		}


		/** 
		Set the value of the LastName input for this Choreo. 

		@param String - (optional, string) The last name of the donor.
		*/
		public void set_LastName(String value) {
			this.setInput("LastName", value);
		}


		/** 
		Set the value of the ProposalId input for this Choreo. 

		@param Integer - (required, integer) The ID of the project that will receive the donation.
		*/
		public void set_ProposalId(Integer value) {
			this.setInput("ProposalId", value);
		}

		/** 
		Set the value of the ProposalId input for this Choreo as a String. 

		@param String - (required, integer) The ID of the project that will receive the donation.
		*/
		public void set_ProposalId(String value) {
			this.setInput("ProposalId", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Salutation input for this Choreo. 

		@param String - (optional, string) Hwo the donor wants to be acknowledged on donorschoose.org.
		*/
		public void set_Salutation(String value) {
			this.setInput("Salutation", value);
		}


		/** 
		Set the value of the State input for this Choreo. 

		@param String - (optional, string) The donor's state.
		*/
		public void set_State(String value) {
			this.setInput("State", value);
		}


		/** 
		Set the value of the Zip input for this Choreo. 

		@param String - (optional, string) The donor's five-digit zip code.
		*/
		public void set_Zip(String value) {
			this.setInput("Zip", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the DonateToProject Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class DonateToProjectResultSet extends ResultSet {
		public DonateToProjectResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from DonorsChoose.org.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
