package com.temboo.Library.Disqus.Threads;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SubscribeToThread

Subscribe to a thread.
*/
public class SubscribeToThread extends Choreography {

	/**
	Create a new instance of the SubscribeToThread Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SubscribeToThread(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Disqus/Threads/SubscribeToThread"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SubscribeToThreadInputSet
	*/
	public SubscribeToThreadInputSet newInputSet() {
		return new SubscribeToThreadInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SubscribeToThreadResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SubscribeToThreadResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SubscribeToThread
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SubscribeToThreadInputSet extends InputSet {
		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (conditional, string) An email address to use when subscribing to the thread.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the Forum input for this Choreo. 

		@param Integer - (optional, integer) The forum ID of a thread that is to be subscribed to. Required if setting either ThreadByIdentification, or ThreadByLink.
		*/
		public void set_Forum(Integer value) {
			this.setInput("Forum", value);
		}

		/** 
		Set the value of the Forum input for this Choreo as a String. 

		@param String - (optional, integer) The forum ID of a thread that is to be subscribed to. Required if setting either ThreadByIdentification, or ThreadByLink.
		*/
		public void set_Forum(String value) {
			this.setInput("Forum", value);	
		}
		/** 
		Set the value of the PublicKey input for this Choreo. 

		@param String - (required, string) The Public Key provided by Disqus (AKA the API Key).
		*/
		public void set_PublicKey(String value) {
			this.setInput("PublicKey", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and jsonp.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the ThreadID input for this Choreo. 

		@param Integer - (conditional, integer) Enter an ID of a thread that is to be subscribed to. Required unless specifying ThreadIdentifier or ThreadLink. If using this parameter, ThreadIdentifier cannot be set.
		*/
		public void set_ThreadID(Integer value) {
			this.setInput("ThreadID", value);
		}

		/** 
		Set the value of the ThreadID input for this Choreo as a String. 

		@param String - (conditional, integer) Enter an ID of a thread that is to be subscribed to. Required unless specifying ThreadIdentifier or ThreadLink. If using this parameter, ThreadIdentifier cannot be set.
		*/
		public void set_ThreadID(String value) {
			this.setInput("ThreadID", value);	
		}
		/** 
		Set the value of the ThreadIdentifier input for this Choreo. 

		@param String - (conditional, string) The identifier for the thread that is to be subscribed to.  Note that a Forum must also be provided when using this parameter. If set, ThreadID and ThreadLink cannot be used.
		*/
		public void set_ThreadIdentifier(String value) {
			this.setInput("ThreadIdentifier", value);
		}


		/** 
		Set the value of the ThreadLink input for this Choreo. 

		@param String - (conditional, string) A link pointing to the thread that is to be subscribed to. Note that a Forum must also be provided when using this parameter. If set, ThreadID and ThreadIdentifier cannot be set.
		*/
		public void set_ThreadLink(String value) {
			this.setInput("ThreadLink", value);
		}


		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - 
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SubscribeToThread Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SubscribeToThreadResultSet extends ResultSet {
		public SubscribeToThreadResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Disqus.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
