package com.temboo.Library.CloudMine.ObjectStorage;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ObjectUpdate

Allows you to update, merge, or create key/value pairs.

*/
public class ObjectUpdate extends Choreography {

	/**
	Create a new instance of the ObjectUpdate Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ObjectUpdate(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/CloudMine/ObjectStorage/ObjectUpdate"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ObjectUpdateInputSet
	*/
	public ObjectUpdateInputSet newInputSet() {
		return new ObjectUpdateInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ObjectUpdateResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ObjectUpdateResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ObjectUpdate
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ObjectUpdateInputSet extends InputSet {
		/** 
		Set the value of the Data input for this Choreo. 

		@param String - (required, json) A valid JSON object containing key/value pairs.
		*/
		public void set_Data(String value) {
			this.setInput("Data", value);
		}


		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by CloudMine after registering your app.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the ApplicationIdentifier input for this Choreo. 

		@param String - (required, string) The application identifier provided by CloudMine after registering your app.
		*/
		public void set_ApplicationIdentifier(String value) {
			this.setInput("ApplicationIdentifier", value);
		}


		/** 
		Set the value of the SessionToken input for this Choreo. 

		@param String - (conditional, string) The session token for an existing user (returned by the AccountLogin Choreo). This is only required if your app is performing this operation on behalf of another user.
		*/
		public void set_SessionToken(String value) {
			this.setInput("SessionToken", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ObjectUpdate Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ObjectUpdateResultSet extends ResultSet {
		public ObjectUpdateResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from CloudMine.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
