package com.temboo.Library.Basecamp;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateEntry

Updates a calendar event or milestone in a project you specify. 
*/
public class UpdateEntry extends Choreography {

	/**
	Create a new instance of the UpdateEntry Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateEntry(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Basecamp/UpdateEntry"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateEntryInputSet
	*/
	public UpdateEntryInputSet newInputSet() {
		return new UpdateEntryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateEntryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateEntryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateEntry
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateEntryInputSet extends InputSet {
		/** 
		Set the value of the AccountName input for this Choreo. 

		@param String - (required, string) A valid Basecamp account name. This is the first part of the account's URL.
		*/
		public void set_AccountName(String value) {
			this.setInput("AccountName", value);
		}


		/** 
		Set the value of the EndDate input for this Choreo. 

		@param String - (required, date) The new end date for the updated entry, in the format YYYY-MM-DD.
		*/
		public void set_EndDate(String value) {
			this.setInput("EndDate", value);
		}


		/** 
		Set the value of the EntryID input for this Choreo. 

		@param Integer - (required, integer) The ID for the calendar entry to update.
		*/
		public void set_EntryID(Integer value) {
			this.setInput("EntryID", value);
		}

		/** 
		Set the value of the EntryID input for this Choreo as a String. 

		@param String - (required, integer) The ID for the calendar entry to update.
		*/
		public void set_EntryID(String value) {
			this.setInput("EntryID", value);	
		}
		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) The Basecamp account password. Use the value 'X' when specifying an API Key for the Username input.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the ProjectID input for this Choreo. 

		@param Integer - (required, integer) The ID of the project with the calendar entry to update.
		*/
		public void set_ProjectID(Integer value) {
			this.setInput("ProjectID", value);
		}

		/** 
		Set the value of the ProjectID input for this Choreo as a String. 

		@param String - (required, integer) The ID of the project with the calendar entry to update.
		*/
		public void set_ProjectID(String value) {
			this.setInput("ProjectID", value);	
		}
		/** 
		Set the value of the ResponsibleParty input for this Choreo. 

		@param String - (optional, any) The user ID or company ID (preceded by a “c”, as in "c1234") to reassign the entry to. Applies only to "Milestone" entry types.
		*/
		public void set_ResponsibleParty(String value) {
			this.setInput("ResponsibleParty", value);
		}


		/** 
		Set the value of the StartDate input for this Choreo. 

		@param String - (optional, date) The new start date for the updated entry, in the format YYYY-MM-DD.
		*/
		public void set_StartDate(String value) {
			this.setInput("StartDate", value);
		}


		/** 
		Set the value of the Title input for this Choreo. 

		@param String - (optional, string) The new title for the updated entry.
		*/
		public void set_Title(String value) {
			this.setInput("Title", value);
		}


		/** 
		Set the value of the Type input for this Choreo. 

		@param String - (optional, string) The new type for the updated entry, either "CalendarEvent" (the default) or "Milestone".
		*/
		public void set_Type(String value) {
			this.setInput("Type", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) A Basecamp account username or API Key.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateEntry Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateEntryResultSet extends ResultSet {
		public UpdateEntryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "TemplateOutput" output from this Choreo execution

		@return String - The request created from the input template.
		*/
		public String get_TemplateOutput() {
			return this.getResultString("TemplateOutput");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response returned from Basecamp.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
