package com.temboo.Library.Basecamp;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetMessages

Retrieves a list of messages associated with a specified project.
*/
public class GetMessages extends Choreography {

	/**
	Create a new instance of the GetMessages Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetMessages(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Basecamp/GetMessages"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetMessagesInputSet
	*/
	public GetMessagesInputSet newInputSet() {
		return new GetMessagesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetMessagesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetMessagesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetMessages
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetMessagesInputSet extends InputSet {
		/** 
		Set the value of the AccountName input for this Choreo. 

		@param String - (required, string) The Basecamp account name for you or your company. This is the first part of your account URL.
		*/
		public void set_AccountName(String value) {
			this.setInput("AccountName", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Your Basecamp password.  You can use the value 'X' when specifying an API Key for the Username input.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the ProjectID input for this Choreo. 

		@param Integer - (required, integer) The ID for the project associated with the messages you want to retrieve.
		*/
		public void set_ProjectID(Integer value) {
			this.setInput("ProjectID", value);
		}

		/** 
		Set the value of the ProjectID input for this Choreo as a String. 

		@param String - (required, integer) The ID for the project associated with the messages you want to retrieve.
		*/
		public void set_ProjectID(String value) {
			this.setInput("ProjectID", value);	
		}
		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) Your Basecamp username or API Key.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetMessages Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetMessagesResultSet extends ResultSet {
		public GetMessagesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Basecamp.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
