package com.temboo.Library.Amazon.Marketplace.Reports;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetReportRequestList

Returns a list of report requests that you can use to get the ReportProcessingStatus and ReportId in order to retrieve a report.
*/
public class GetReportRequestList extends Choreography {

	/**
	Create a new instance of the GetReportRequestList Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetReportRequestList(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/Marketplace/Reports/GetReportRequestList"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetReportRequestListInputSet
	*/
	public GetReportRequestListInputSet newInputSet() {
		return new GetReportRequestListInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetReportRequestListResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetReportRequestListResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetReportRequestList
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetReportRequestListInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSMarketplaceId input for this Choreo. 

		@param String - (required, string) The Marketplace ID provided by Amazon Web Services.
		*/
		public void set_AWSMarketplaceId(String value) {
			this.setInput("AWSMarketplaceId", value);
		}


		/** 
		Set the value of the AWSMerchantId input for this Choreo. 

		@param String - (required, string) The Merchant ID provided by Amazon Web Services.
		*/
		public void set_AWSMerchantId(String value) {
			this.setInput("AWSMerchantId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the Endpoint input for this Choreo. 

		@param String - (conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
		*/
		public void set_Endpoint(String value) {
			this.setInput("Endpoint", value);
		}


		/** 
		Set the value of the MWSAuthToken input for this Choreo. 

		@param String - (optional, string) The Amazon MWS authorization token for the given seller and developer.
		*/
		public void set_MWSAuthToken(String value) {
			this.setInput("MWSAuthToken", value);
		}


		/** 
		Set the value of the MaxCount input for this Choreo. 

		@param Integer - (optional, integer) A non-negative integer that represents the maximum number of report requests to return. Defaults to 10. Max is 100.
		*/
		public void set_MaxCount(Integer value) {
			this.setInput("MaxCount", value);
		}

		/** 
		Set the value of the MaxCount input for this Choreo as a String. 

		@param String - (optional, integer) A non-negative integer that represents the maximum number of report requests to return. Defaults to 10. Max is 100.
		*/
		public void set_MaxCount(String value) {
			this.setInput("MaxCount", value);	
		}
		/** 
		Set the value of the ReportProcessingStatusList input for this Choreo. 

		@param String - (optional, string) A comma separated list of up to three ReportProcessingStatuses by which to filter report requests.
		*/
		public void set_ReportProcessingStatusList(String value) {
			this.setInput("ReportProcessingStatusList", value);
		}


		/** 
		Set the value of the ReportRequestIdList input for this Choreo. 

		@param String - (optional, string) A comma separated list of up to three ReportRequestId values. If you pass in a ReportRequestId values, other query conditions are ignored.
		*/
		public void set_ReportRequestIdList(String value) {
			this.setInput("ReportRequestIdList", value);
		}


		/** 
		Set the value of the ReportTypeList input for this Choreo. 

		@param String - (optional, string) A comma separated list of up to three ReportType enumeration values.
		*/
		public void set_ReportTypeList(String value) {
			this.setInput("ReportTypeList", value);
		}


		/** 
		Set the value of the RequestedFromDate input for this Choreo. 

		@param String - (optional, date) The start of the date range used for selecting the data to report, in ISO8601 date format (i.e. 2012-01-01).
		*/
		public void set_RequestedFromDate(String value) {
			this.setInput("RequestedFromDate", value);
		}


		/** 
		Set the value of the RequestedToDate input for this Choreo. 

		@param String - (optional, date) The end of the date range used for selecting the data to report, in ISO8601 date format (i.e. 2012-01-01).
		*/
		public void set_RequestedToDate(String value) {
			this.setInput("RequestedToDate", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetReportRequestList Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetReportRequestListResultSet extends ResultSet {
		public GetReportRequestListResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "GeneratedReportId" output from this Choreo execution

		@return String - (integer) The GeneratedReportId parsed from the Amazon response. If multiple records are returned, this output variable will contain the first id in the list.
		*/
		public String get_GeneratedReportId() {
			return this.getResultString("GeneratedReportId");
		}
		/** 
		Retrieve the value for the "ReportProcessingStatus" output from this Choreo execution

		@return String - (string) The report status parsed from the Amazon response. If multiple records are returned, this output variable will contain the report status in the list.
		*/
		public String get_ReportProcessingStatus() {
			return this.getResultString("ReportProcessingStatus");
		}
		/** 
		Retrieve the value for the "ReportRequestId" output from this Choreo execution

		@return String - (integer) The report request id parsed from the Amazon response. If multiple records are returned, this output variable will contain the first id in the list.
		*/
		public String get_ReportRequestId() {
			return this.getResultString("ReportRequestId");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - Stores the response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
