package com.temboo.Library.Amazon.Marketplace.Inventory;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListInventorySupplyByDateRange

Returns information about the availability of a seller's inventory using a given date range.
*/
public class ListInventorySupplyByDateRange extends Choreography {

	/**
	Create a new instance of the ListInventorySupplyByDateRange Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListInventorySupplyByDateRange(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/Marketplace/Inventory/ListInventorySupplyByDateRange"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListInventorySupplyByDateRangeInputSet
	*/
	public ListInventorySupplyByDateRangeInputSet newInputSet() {
		return new ListInventorySupplyByDateRangeInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListInventorySupplyByDateRangeResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListInventorySupplyByDateRangeResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListInventorySupplyByDateRange
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListInventorySupplyByDateRangeInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSMarketplaceId input for this Choreo. 

		@param String - (required, string) The Marketplace ID provided by Amazon Web Services.
		*/
		public void set_AWSMarketplaceId(String value) {
			this.setInput("AWSMarketplaceId", value);
		}


		/** 
		Set the value of the AWSMerchantId input for this Choreo. 

		@param String - (required, string) The Merchant ID provided by Amazon Web Services.
		*/
		public void set_AWSMerchantId(String value) {
			this.setInput("AWSMerchantId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the Endpoint input for this Choreo. 

		@param String - (conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
		*/
		public void set_Endpoint(String value) {
			this.setInput("Endpoint", value);
		}


		/** 
		Set the value of the MWSAuthToken input for this Choreo. 

		@param String - (optional, string) The Amazon MWS authorization token for the given seller and developer.
		*/
		public void set_MWSAuthToken(String value) {
			this.setInput("MWSAuthToken", value);
		}


		/** 
		Set the value of the PageToken input for this Choreo. 

		@param String - (conditional, string) The value returned in the NextPageToken output of this Choreo when there are multiple pages of inventory items to retrieve. Required unless providing QueryStartDateTime.
		*/
		public void set_PageToken(String value) {
			this.setInput("PageToken", value);
		}


		/** 
		Set the value of the QueryStartDateTime input for this Choreo. 

		@param String - (conditional, date) A date used for selecting items that have had changes in inventory availability after (or at) a specified time, in ISO 8601 date format (i.e. 2012-01-01). Required unless providing PageToken.
		*/
		public void set_QueryStartDateTime(String value) {
			this.setInput("QueryStartDateTime", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the ResponseGroup input for this Choreo. 

		@param String - (optional, string) Indicates whether or not to return the SupplyDetail element in the response. Valid values are: "Basic" (does not include SupplyDetail), and "Detailed" (includes SupplyDetail). Defaults to "Basic".
		*/
		public void set_ResponseGroup(String value) {
			this.setInput("ResponseGroup", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListInventorySupplyByDateRange Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListInventorySupplyByDateRangeResultSet extends ResultSet {
		public ListInventorySupplyByDateRangeResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "NextPageToken" output from this Choreo execution

		@return String - (string) A token used to retrieve the next page of results. If a token is not returned, there are no more results to retrieve. This token can be passed to the PageToken input of this Choreo.
		*/
		public String get_NextPageToken() {
			return this.getResultString("NextPageToken");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - Stores the response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
