package com.temboo.Library.Amazon.MachineLearning;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateMLModel

Creates a new MLModel using the DataSource and the recipe as information sources.
*/
public class CreateMLModel extends Choreography {

	/**
	Create a new instance of the CreateMLModel Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateMLModel(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/MachineLearning/CreateMLModel"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateMLModelInputSet
	*/
	public CreateMLModelInputSet newInputSet() {
		return new CreateMLModelInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateMLModelResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateMLModelResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateMLModel
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateMLModelInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the MLModelId input for this Choreo. 

		@param String - (required, string) A user-supplied identifier that uniquely identifies the MLModel.
		*/
		public void set_MLModelId(String value) {
			this.setInput("MLModelId", value);
		}


		/** 
		Set the value of the MLModelName input for this Choreo. 

		@param String - (optional, string) A user-supplied name or description of the MLModel.
		*/
		public void set_MLModelName(String value) {
			this.setInput("MLModelName", value);
		}


		/** 
		Set the value of the MLModelType input for this Choreo. 

		@param String - (required, string) The category of supervised learning that this MLModel will address. Choose from the following types: REGRESSION, BINARY, MULTICLASS.
		*/
		public void set_MLModelType(String value) {
			this.setInput("MLModelType", value);
		}


		/** 
		Set the value of the Parameters input for this Choreo. 

		@param String - (optional, json) A list of the training parameters in the MLModel. The list is implemented as a map of key-value pairs.
		*/
		public void set_Parameters(String value) {
			this.setInput("Parameters", value);
		}


		/** 
		Set the value of the Recipe input for this Choreo. 

		@param String - (optional, string) The data recipe for creating the MLModel. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.
		*/
		public void set_Recipe(String value) {
			this.setInput("Recipe", value);
		}


		/** 
		Set the value of the RecipeUri input for this Choreo. 

		@param String - (optional, string) The Amazon S3 location and file name that contains the MLModel recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.
		*/
		public void set_RecipeUri(String value) {
			this.setInput("RecipeUri", value);
		}


		/** 
		Set the value of the TrainingDataSourceId input for this Choreo. 

		@param String - (required, string) The DataSource that points to the training data.
		*/
		public void set_TrainingDataSourceId(String value) {
			this.setInput("TrainingDataSourceId", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateMLModel Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateMLModelResultSet extends ResultSet {
		public CreateMLModelResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
