package com.temboo.Library.eBay.Trading;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetItem

Returns item data such as title, description, price information, and seller information.
*/
public class GetItem extends Choreography {

	/**
	Create a new instance of the GetItem Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetItem(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/eBay/Trading/GetItem"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetItemInputSet
	*/
	public GetItemInputSet newInputSet() {
		return new GetItemInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetItemResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetItemResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetItem
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetItemInputSet extends InputSet {
		/** 
		Set the value of the DetailLevel input for this Choreo. 

		@param String - (optional, string) The response detail level. Valid values are: ItemReturnAttributes, ItemReturnDescription, and ReturnAll.
		*/
		public void set_DetailLevel(String value) {
			this.setInput("DetailLevel", value);
		}


		/** 
		Set the value of the IncludeItemSpecifics input for this Choreo. 

		@param Boolean - (optional, boolean) If set to true, the response returns the ItemSpecifics node (if the listing has custom Item Specifics).
		*/
		public void set_IncludeItemSpecifics(Boolean value) {
			this.setInput("IncludeItemSpecifics", value);
		}

		/** 
		Set the value of the IncludeItemSpecifics input for this Choreo as a String. 

		@param String - (optional, boolean) If set to true, the response returns the ItemSpecifics node (if the listing has custom Item Specifics).
		*/
		public void set_IncludeItemSpecifics(String value) {
			this.setInput("IncludeItemSpecifics", value);	
		}
		/** 
		Set the value of the IncludeTaxTable input for this Choreo. 

		@param Boolean - (optional, boolean) If set to true, an associated tax table is returned in the response.
		*/
		public void set_IncludeTaxTable(Boolean value) {
			this.setInput("IncludeTaxTable", value);
		}

		/** 
		Set the value of the IncludeTaxTable input for this Choreo as a String. 

		@param String - (optional, boolean) If set to true, an associated tax table is returned in the response.
		*/
		public void set_IncludeTaxTable(String value) {
			this.setInput("IncludeTaxTable", value);	
		}
		/** 
		Set the value of the IncludeWatchCount input for this Choreo. 

		@param Boolean - (optional, boolean) Indicates if the caller wants to include watch count for that item in the response when set to true. Only the seller is allowed to use this argument.
		*/
		public void set_IncludeWatchCount(Boolean value) {
			this.setInput("IncludeWatchCount", value);
		}

		/** 
		Set the value of the IncludeWatchCount input for this Choreo as a String. 

		@param String - (optional, boolean) Indicates if the caller wants to include watch count for that item in the response when set to true. Only the seller is allowed to use this argument.
		*/
		public void set_IncludeWatchCount(String value) {
			this.setInput("IncludeWatchCount", value);	
		}
		/** 
		Set the value of the ItemID input for this Choreo. 

		@param String - (required, string) The ItemID that uniquely identifies the item listing to retrieve.
		*/
		public void set_ItemID(String value) {
			this.setInput("ItemID", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SandboxMode input for this Choreo. 

		@param Boolean - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(Boolean value) {
			this.setInput("SandboxMode", value);
		}

		/** 
		Set the value of the SandboxMode input for this Choreo as a String. 

		@param String - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(String value) {
			this.setInput("SandboxMode", value);	
		}
		/** 
		Set the value of the SiteID input for this Choreo. 

		@param String - (optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
		*/
		public void set_SiteID(String value) {
			this.setInput("SiteID", value);
		}


		/** 
		Set the value of the TransactionID input for this Choreo. 

		@param String - (optional, string) A unique identifier for a transaction (i.e.  an order line item). An order line item is created when the buyer commits to purchasing an item.
		*/
		public void set_TransactionID(String value) {
			this.setInput("TransactionID", value);
		}


		/** 
		Set the value of the UserToken input for this Choreo. 

		@param String - (required, string) A valid eBay Auth Token.
		*/
		public void set_UserToken(String value) {
			this.setInput("UserToken", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetItem Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetItemResultSet extends ResultSet {
		public GetItemResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "CurrentPrice" output from this Choreo execution

		@return String - (decimal) The current price for the item.
		*/
		public String get_CurrentPrice() {
			return this.getResultString("CurrentPrice");
		}
		/** 
		Retrieve the value for the "DaysLeft" output from this Choreo execution

		@return String - (integer) The number of days until the auction ends.
		*/
		public String get_DaysLeft() {
			return this.getResultString("DaysLeft");
		}
		/** 
		Retrieve the value for the "HoursLeft" output from this Choreo execution

		@return String - (integer) The number of hours until the auction ends.
		*/
		public String get_HoursLeft() {
			return this.getResultString("HoursLeft");
		}
		/** 
		Retrieve the value for the "MinutesLeft" output from this Choreo execution

		@return String - (integer) The number of minutes until the auction ends.
		*/
		public String get_MinutesLeft() {
			return this.getResultString("MinutesLeft");
		}
		/** 
		Retrieve the value for the "SecondsLeft" output from this Choreo execution

		@return String - (integer) The number of seconds until the auction ends.
		*/
		public String get_SecondsLeft() {
			return this.getResultString("SecondsLeft");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from eBay.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
