package com.temboo.Library.Yahoo.Weather;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetWeatherByCoordinates

Retrieves the Yahoo Weather RSS Feed for any specified location by geo-coordinates.
*/
public class GetWeatherByCoordinates extends Choreography {

	/**
	Create a new instance of the GetWeatherByCoordinates Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetWeatherByCoordinates(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Yahoo/Weather/GetWeatherByCoordinates"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetWeatherByCoordinatesInputSet
	*/
	public GetWeatherByCoordinatesInputSet newInputSet() {
		return new GetWeatherByCoordinatesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetWeatherByCoordinatesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetWeatherByCoordinatesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetWeatherByCoordinates
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetWeatherByCoordinatesInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (optional, string) Deprecated (retained for backward compatibility only).
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the Day input for this Choreo. 

		@param Integer - (optional, integer) An index in the range 1 to 5 that corresponds to the forecast day you want to retrieve. Today corresponds to 1, tomorrow corresponds to 2, and so on. Defaults to 1.
		*/
		public void set_Day(Integer value) {
			this.setInput("Day", value);
		}

		/** 
		Set the value of the Day input for this Choreo as a String. 

		@param String - (optional, integer) An index in the range 1 to 5 that corresponds to the forecast day you want to retrieve. Today corresponds to 1, tomorrow corresponds to 2, and so on. Defaults to 1.
		*/
		public void set_Day(String value) {
			this.setInput("Day", value);	
		}
		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The latitude coordinate of the location you want to search (e.g., 38.898717).
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (required, decimal) The latitude coordinate of the location you want to search (e.g., 38.898717).
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The longitude coordinate of the location you want to search (e.g., -77.035974).
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (required, decimal) The longitude coordinate of the location you want to search (e.g., -77.035974).
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Units input for this Choreo. 

		@param String - (optional, string) The unit of temperature in the response. Acceptable inputs: f for Fahrenheit or c for Celsius. Defaults to f. When c is specified, all units measurements returned are changed to metric.
		*/
		public void set_Units(String value) {
			this.setInput("Units", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetWeatherByCoordinates Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetWeatherByCoordinatesResultSet extends ResultSet {
		public GetWeatherByCoordinatesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "ConditionCode" output from this Choreo execution

		@return String - (integer) A code representing the current condition.
		*/
		public String get_ConditionCode() {
			return this.getResultString("ConditionCode");
		}
		/** 
		Retrieve the value for the "ConditionText" output from this Choreo execution

		@return String - (string) The textual description for the current condition.
		*/
		public String get_ConditionText() {
			return this.getResultString("ConditionText");
		}
		/** 
		Retrieve the value for the "ForecastCode" output from this Choreo execution

		@return String - (integer) A code representing the forecast condition.
		*/
		public String get_ForecastCode() {
			return this.getResultString("ForecastCode");
		}
		/** 
		Retrieve the value for the "ForecastText" output from this Choreo execution

		@return String - (string) The textual description for the specified day's forecast condition.
		*/
		public String get_ForecastText() {
			return this.getResultString("ForecastText");
		}
		/** 
		Retrieve the value for the "High" output from this Choreo execution

		@return String - (integer) The high temperature forecast for the specified day.
		*/
		public String get_High() {
			return this.getResultString("High");
		}
		/** 
		Retrieve the value for the "Humidity" output from this Choreo execution

		@return String - (decimal) The current measurement for atmospheric humidity.
		*/
		public String get_Humidity() {
			return this.getResultString("Humidity");
		}
		/** 
		Retrieve the value for the "Low" output from this Choreo execution

		@return String - (integer) The low temperature forecast for the specified day.
		*/
		public String get_Low() {
			return this.getResultString("Low");
		}
		/** 
		Retrieve the value for the "Pressure" output from this Choreo execution

		@return String - (decimal) The current measurement for atmospheric pressure.
		*/
		public String get_Pressure() {
			return this.getResultString("Pressure");
		}
		/** 
		Retrieve the value for the "Temperature" output from this Choreo execution

		@return String - (integer) The current temperature.
		*/
		public String get_Temperature() {
			return this.getResultString("Temperature");
		}
		/** 
		Retrieve the value for the "Visibility" output from this Choreo execution

		@return String - (decimal) The current measurement for visibility.
		*/
		public String get_Visibility() {
			return this.getResultString("Visibility");
		}
		/** 
		Retrieve the value for the "WOEID" output from this Choreo execution

		@return String - (integer) The unique Where On Earth ID of the location.
		*/
		public String get_WOEID() {
			return this.getResultString("WOEID");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Yahoo Weather.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
