package com.temboo.Library.Utilities.DataConversions;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
JSONToXML

Converts data from JSON format to XML format.
*/
public class JSONToXML extends Choreography {

	/**
	Create a new instance of the JSONToXML Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public JSONToXML(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/DataConversions/JSONToXML"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return JSONToXMLInputSet
	*/
	public JSONToXMLInputSet newInputSet() {
		return new JSONToXMLInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public JSONToXMLResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new JSONToXMLResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the JSONToXML
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class JSONToXMLInputSet extends InputSet {
		/** 
		Set the value of the JSON input for this Choreo. 

		@param String - (required, json) The JSON data that you want to convert to XML.
		*/
		public void set_JSON(String value) {
			this.setInput("JSON", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the JSONToXML Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class JSONToXMLResultSet extends ResultSet {
		public JSONToXMLResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "XML" output from this Choreo execution

		@return String - (xml) The converted data in XML format.
		*/
		public String get_XML() {
			return this.getResultString("XML");
		}
	}
	
}
