package com.temboo.Library.Twitter.Lists;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetSubscribers

Retrieves the subscribers for a specified list.
*/
public class GetSubscribers extends Choreography {

	/**
	Create a new instance of the GetSubscribers Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetSubscribers(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Twitter/Lists/GetSubscribers"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetSubscribersInputSet
	*/
	public GetSubscribersInputSet newInputSet() {
		return new GetSubscribersInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetSubscribersResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetSubscribersResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetSubscribers
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetSubscribersInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the ConsumerKey input for this Choreo. 

		@param String - (required, string) The API Key (or Consumer Key) provided by Twitter.
		*/
		public void set_ConsumerKey(String value) {
			this.setInput("ConsumerKey", value);
		}


		/** 
		Set the value of the ConsumerSecret input for this Choreo. 

		@param String - (required, string) The API Secret (or Consumer Secret) provided by Twitter.
		*/
		public void set_ConsumerSecret(String value) {
			this.setInput("ConsumerSecret", value);
		}


		/** 
		Set the value of the Cursor input for this Choreo. 

		@param String - (optional, string) Allows you to pass in the previous_cursor or next_cursor in order to page through results.
		*/
		public void set_Cursor(String value) {
			this.setInput("Cursor", value);
		}


		/** 
		Set the value of the IncludeEntities input for this Choreo. 

		@param Boolean - (optional, boolean) The "entities" node containing extra metadata will not be included when set to false.
		*/
		public void set_IncludeEntities(Boolean value) {
			this.setInput("IncludeEntities", value);
		}

		/** 
		Set the value of the IncludeEntities input for this Choreo as a String. 

		@param String - (optional, boolean) The "entities" node containing extra metadata will not be included when set to false.
		*/
		public void set_IncludeEntities(String value) {
			this.setInput("IncludeEntities", value);	
		}
		/** 
		Set the value of the ListId input for this Choreo. 

		@param String - (conditional, string) The numerical ID of the list. Required unless Slug is provided.
		*/
		public void set_ListId(String value) {
			this.setInput("ListId", value);
		}


		/** 
		Set the value of the OwnerId input for this Choreo. 

		@param String - (optional, string) The user ID of the user who owns the list being requested by a slug.
		*/
		public void set_OwnerId(String value) {
			this.setInput("OwnerId", value);
		}


		/** 
		Set the value of the OwnerScreenName input for this Choreo. 

		@param String - (optional, string) The screen name of the user who owns the list being requested by a slug.
		*/
		public void set_OwnerScreenName(String value) {
			this.setInput("OwnerScreenName", value);
		}


		/** 
		Set the value of the SkipStatus input for this Choreo. 

		@param Boolean - (optional, boolean) When set to either true, statuses will not be included in the returned user objects.
		*/
		public void set_SkipStatus(Boolean value) {
			this.setInput("SkipStatus", value);
		}

		/** 
		Set the value of the SkipStatus input for this Choreo as a String. 

		@param String - (optional, boolean) When set to either true, statuses will not be included in the returned user objects.
		*/
		public void set_SkipStatus(String value) {
			this.setInput("SkipStatus", value);	
		}
		/** 
		Set the value of the Slug input for this Choreo. 

		@param String - (optional, string) When identifying a list by a slug, either OwnerScreenName or OwnerId must be provided.
		*/
		public void set_Slug(String value) {
			this.setInput("Slug", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetSubscribers Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetSubscribersResultSet extends ResultSet {
		public GetSubscribersResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Limit" output from this Choreo execution

		@return String - (integer) The rate limit ceiling for this particular request.
		*/
		public String get_Limit() {
			return this.getResultString("Limit");
		}
		/** 
		Retrieve the value for the "Remaining" output from this Choreo execution

		@return String - (integer) The number of requests left for the 15 minute window.
		*/
		public String get_Remaining() {
			return this.getResultString("Remaining");
		}
		/** 
		Retrieve the value for the "Reset" output from this Choreo execution

		@return String - (date) The remaining window before the rate limit resets in UTC epoch seconds.
		*/
		public String get_Reset() {
			return this.getResultString("Reset");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Twitter.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
